/*
 * SeqTrajectory.cpp
 *
 *  Created on: 2009/10/29
 *      Author: ox
 */

#include "SeqTrajectory.h"
#include "Layout.h"

SeqTrajectory::SeqTrajectory(GridFigureFactory &figureFactory, Sequence *seq, InputEvents &inputEvents,
		float width, float height) :
	figureFactory(figureFactory),
	sequence(seq),
	width(width), height(height),
	color(Layout::SeqTrajColor),
	highColor(Layout::SeqTrajHighColor)
{
	width_over = 1.0 / width;
	height_over = 1.0 / height;
	for(int i = 0; i < seq->size(); i++) {
		InputEvent ie = inputEvents.get(seq->at(i).id);// eSequence::MessageɑΉInputEvent擾
		if(ie.type == INPUT_TYPE_GRID) {
			events.push_back(ie);
		}
	}
}

SeqTrajectory::~SeqTrajectory() {
	// TODO Auto-generated destructor stub
}


/*!
 * w肵sNZl܂Cell`
 */
inline void SeqTrajectory::drawInputPoint(InputEvent &ie)
{
	float alpha = 0.5;

//	float nx = ie.data1 * width_over;
//	float ny = ie.data2 * height_over;
//
//	CellFigureHandle *handle1 = figureFactory.drawCell(nx, ny, 1, alpha, false);
	CellFigureHandle *handle1 = figureFactory.drawCell(ie.data1, ie.data2, 1, alpha, false);
	handle1->setColor(color);
	figureHandles.push_back(handle1);
}

/*!
 * w肵2_(ie1 -> ie2)Ȃ`
 */
inline void SeqTrajectory::drawCellLine(InputEvent &ie1, InputEvent &ie2)
{
//	float nx1 = ie1.data1 * width_over;
//	float ny1 = ie1.data2 * height_over;
//	float nx2 = ie2.data1 * width_over;
//	float ny2 = ie2.data2 * height_over;
//
//	CellFigureHandle *lineHandle = figureFactory.drawConnection(nx1, ny1, nx2, ny2);

	CellFigureHandle *lineHandle = figureFactory.drawConnection(ie1.data1, ie1.data2, ie2.data1, ie2.data2);

	lineHandle->setColor(color);
	figureHandles.push_back(lineHandle);
}


void SeqTrajectory::show()
{
	figureMutex.lock();
	if(events.size() > 0) {		// ̓Cxg
		showing = true;
		vector<InputEvent>::iterator itr = events.begin();
		InputEvent ie = *itr;	// NԖڂ̓̓Cxgp
		InputEvent ie2;			//
		itr++;
		for(; itr != events.end(); itr++) {
			ie2 = *itr;			// N+1Ԗڂ̓̓Cxgp
			drawInputPoint(ie);	// NԖڂ̓̓|Cg`
			drawCellLine(ie, ie2);	// N - N+1̓CxgԂŐ`悷
			ie = ie2;
		}
	}
	figureMutex.unlock();
}

void SeqTrajectory::hide()
{
	figureMutex.lock();
	for(unsigned int i = 0; i < figureHandles.size(); i++) {
		CellFigureHandle *h = figureHandles.at(i);
		h->updateDelete(3);		// `撆̃IuWFNg
	}
	figureHandles.clear();		// `IuWFNg̃xN^NA
	showing = false;
	figureMutex.unlock();
}

void SeqTrajectory::highlight(bool t)
{
	figureMutex.lock();
	Colorful col = t ? highColor : color;
	for(unsigned int i = 0; i < figureHandles.size(); i++) {
		CellFigureHandle *h = figureHandles.at(i);
		h->setColor(col);		// `撆̃IuWFNg̐FύX
	}
	figureMutex.unlock();
}
