/*
 * SequenceArea.cpp
 *
 *  Created on: 2009/09/15
 *      Author: sambuichi
 */

#include "SequenceArea.h"
#include "SynthFactory.h"
#include "graphic/comp/InputEvents.h"
#include "graphic/updater/UpdaterGrPort.h"
#include "graphic/updater/UpdaterKillUnit.h"
#include "graphic/text/FTLabelFactory.h"
#include "Layout.h"

SequenceArea::SequenceArea(GridFigureFactory &figureFactory, Sequence *sequence, InputEvents &inputEvents,
		float width, float height) :
	figureFactory(figureFactory), sequence(sequence), figure(0), label(0),
	width(width), height(height), sequenceAreaViewing(false)
{
	width_over = 1.0 / width;
	height_over = 1.0 / height;
	entryInputArea(sequence, inputEvents);
}

SequenceArea::~SequenceArea() {
	// TODO Auto-generated destructor stub
}


/*!
 * seqInputEvent̒őAŏlGA쐬Ao^
 */
void SequenceArea::entryInputArea(Sequence *seq, InputEvents &inputEvents) {
	Area area;
	for(int i = 0; i < seq->size(); i++) {
		InputEvent ie = inputEvents.get(seq->at(i).id);// eSequence::MessageɑΉInputEvent擾
		if(ie.type == INPUT_TYPE_MOUSE) {
			if(ie.data1 > area.maxx) {	// SequenceInputEvent̂ȂōőmouseXlێ
				area.maxx = ie.data1;
			}
			if(ie.data1 < area.minx) {	// SequenceInputEvent̂ȂōŏmouseXlێ
				area.minx = ie.data1;
			}
			if(ie.data2 > area.maxy) {	// SequenceInputEvent̂ȂōőmouseXlێ
				area.maxy = ie.data2;
			}
			if(ie.data2 < area.miny) {	// SequenceInputEvent̂ȂōŏmouseXlێ
				area.miny = ie.data2;
			}
		}
	}
	areaMapMutex.lock();
	this->area = area;
	areaMapMutex.unlock();
}

inline string SequenceArea::getAreaString() {
	//! seq̃x`
	int channel = sequence->getChannel();
	char charstr[64];
	sprintf(charstr, "%d", channel);
	string channelStr = charstr;
	Synth *synth = SynthFactory::getSynthAt(channel);
	string l = "noSynth";
	if(synth) {
		l = synth->getName() + "  ch:" + channelStr;
	}
	return l;
}

/*!
 * L^V[PX̃GA`A`nh}bvɒǉ
 * currentSequenceȂǁA܂o^ĂȂV[PX̏ꍇ͕`悹0Ԃ
 */
void SequenceArea::show()
{
	if(!sequenceAreaViewing) {
		sequenceAreaViewing = true;

		//! seq̃GA\``
		GridFigureFactory::CellFigureHandle *handle = figureFactory.drawArea(area.maxx*width_over,
				area.maxy*height_over, area.minx*width_over, area.miny*height_over, 0.2);

//		float gridx = figureFactory.gm.toGridX(area.minx*width_over);
//		float gridy = figureFactory.gm.toGridY(area.miny*height_over);
//		ftlabel *label = FTLabelFactory::getInstance()->simpleLabel(getAreaString(), gridx, gridy, 0.03);
		ftlabel *label = FTLabelFactory::getInstance()->simpleLabel(getAreaString(), area.minx, area.miny, 0.03);
		label->setColor(Layout::SequenceAreaLabelColor);
		GlutMain::addUnit(label);	// ς肱ꂪȂƂƏĂȂ

		// SequenceƃGA`nh}bvɓo^
		this->figure = handle;
		this->label = label;
	}
}

/*!
 * V[PX̃GA`Figure폜A`nh}bv菜
 * currentSequenceȂǁA܂o^ĂȂV[PX̏ꍇ͕`悹0Ԃ
 */
void SequenceArea::hide()
{
	if(sequenceAreaViewing) {
		sequenceAreaViewing = false;
		// `FigureCX^X
		if(figure) {
			figure->updateDelete(1);		// `Figure폜
			figure = 0;
		}

		// `labelCX^X
		if(label) {
			label->updateDelete(1);		// label폜
			label = 0;
		}
	}
}

/*!
 * mouseX, mouseYseqInputAreał邩𔻒肷
 */
inline bool SequenceArea::isInputArea(int mouseX, int mouseY)
{
	areaMapMutex.lock();
	bool inArea = false;
	if((mouseX <= area.maxx) && (mouseX >= area.minx) && (mouseY <= area.maxy) && (mouseY >= area.miny)) {
		inArea = true;
	}
	areaMapMutex.unlock();
	return inArea;
}

/*!
 * w肵W̃V[PXGAł邩H
 * \return `FύXꍇTRUE
 */
bool SequenceArea::rollover(int x, int y) {
	if(sequenceAreaViewing) {
		bool inArea = isInputArea(x, y);
		if(!rollovering && inArea) {	// seq̃GAɃ[I[o[ĂȂԂŁ˃[I[o
			cout << "rollover!!" << endl;
			rollovering = true;
			for(int i = 0; i < (int)figure->rects.size(); i++) {
				Rect *rect = figure->rects.at(i);
				rect->updateRed(1.0, 5);
			}
			return true;
		} else if(rollovering && !inArea){	// seq̃GAɃ[I[o[ĂԂŁ˃[I[oO
			rollovering = false;
			cout << "rollover false!!" << endl;
			for(int i = 0; i < (int)figure->rects.size(); i++) {
				Rect *rect = figure->rects.at(i);
				rect->updateRed(0.5, 5);	// ̐Fɖ߂
			}
			return true;
		}
	}
	return false;
}
