/*
 * StepPatternList.cpp
 *
 *  Created on: 2009/10/07
 *      Author: ox
 */

#include "StepPatternListDraw.h"

StepPatternListDraw::StepPatternListDraw(float posx, float posy, UnitMng *mng,
		vector<StepPattern*> &patterns) :
	posx(posx), posy(posy), mng(mng), patterns(patterns), highlightPattern(0),
	grubx(0), gruby(0), movex(0), movey(0), sumMoveY(0), lastStepY(0), grubbing(false)
{
}

StepPatternListDraw::~StepPatternListDraw() {
}

//! public : p^[EXgACe\Aړn_Zbg
void StepPatternListDraw::grub(float x, float y)
{
	// debug 20091101 Xgĕ\ē\ʒu
	lastStepY = ((int)(y / Layout::stepPatternListItemSize)) * Layout::stepPatternListItemSize;
	makeList();					// p^[EXgACe\
	moveListItems(sumMoveY);	// XgACeO\ʒuɈړ

	grubbing = true;
	grubx = x;
	gruby = y;
	movex = x;
	movey = y;
}

//! public : p^[EXgACeړ
void StepPatternListDraw::move(float x, float y) {
	if(grubbing) {
		// y̒lstepPatternListItemSize݂Stepl
		float stepy = ((int)(y / Layout::stepPatternListItemSize)) * Layout::stepPatternListItemSize;
		float stepmy = stepy - lastStepY;	// ÖʒȗΓIȈړ
		lastStepY = stepy;	// Ostepy

		float yy = sumMoveY + stepmy;
		if(((patternSet.size()-1) * Layout::stepPatternListItemSize * -1 <= yy) && (yy <= 0)) {
			sumMoveY += stepmy;			// \ʒũg[^ł̈ړʂXV
			moveListItems(stepmy);		// grub̑ΓIȈړ
		}
	}
}

//! public : p^[EXgACe̕\I
StepPattern *StepPatternListDraw::release(float x, float y) {
	if(grubbing) {
		eraseList();
		grubbing = false;
		return highlightPattern;
	}
	return 0;
}

//! private : eStepPatternDrawSet㉺Ɉړ
inline void StepPatternListDraw::moveListItems(float my)
{
	for(unsigned int i = 0; i < patternSet.size(); i++) {
		StepPatternDrawSet *set = patternSet.at(i);
		set->movey(my);
		if(set->highlightDetection(posy)) {	// ړɃtH[JXĂ邩𔻒肵ĕ\XV
			highlightPattern = set->pattern;
		}
	}
}

//! private : ׂĂStepPatternDrawSet폜
inline void StepPatternListDraw::eraseList()
{
	for(unsigned int i = 0; i < patternSet.size(); i++) {
		StepPatternDrawSet *set = patternSet.at(i);
		delete set;
	}
	patternSet.clear();		// o^ĂACeSNA
}

//! private : ׂĂStepPatternDrawSet쐬
inline void StepPatternListDraw::makeList()
{
	//! patternsׂĕ\
	float y = posy;
	for(unsigned int i = 0; i < patterns.size(); i++) {
		StepPattern *pat = patterns.at(i);
		StepPatternDrawSet *set = new StepPatternDrawSet(pat, posx, y, mng);
		patternSet.push_back(set);
		y += (Layout::stepPatternListRectSize + Layout::stepPatternListLabelRectMargin +
				Layout::stepPatternListLabelSize + Layout::stepPatternListItemMargin);
	}
}



