/*
 * StepPatternSelector.cpp
 *
 *  Created on: 2009/10/14
 *      Author: ox
 */

#include "StepPatternSelector.h"
#include "StepPatternInstance.h"
#include "Layout.h"

StepPatternSelector::StepPatternSelector(UnitMng *mng) :
	mng(mng),
	stepPattern(0),
	stepPatternDraw(0),
	stepPatternList(0)
{
	StepPatternInstance::init();
	stepPattern = StepPatternInstance::at(0);

	stepPatternDraw = new StepPatternDraw(stepPattern, Layout::stepPatternX, Layout::stepPatternY,
			Layout::stepPatternSize, Layout::stepPatternRectsRatio, mng);
	stepPatternDraw->setColor(Layout::StepPatternColor);

	stepPatternList = new StepPatternListDraw(Layout::stepPatternListX, Layout::stepPatternListY,
			mng, StepPatternInstance::getAllItems());
}

StepPatternSelector::~StepPatternSelector() {
	// TODO Auto-generated destructor stub
}

void StepPatternSelector::mouseFunction(float mx, float my, int state)
{
	if(state) {	//! press
		if(stepPatternDraw->isArea(mx, my)) {
			stepPatternList->grub(mx, my);
			delete stepPatternDraw;
		}
	} else {	//! release
		StepPattern *pattern = stepPatternList->release(mx, my);
		if(pattern) {
			cout << "Release new pattern" << endl;
			stepPatternDraw = new StepPatternDraw(pattern, Layout::stepPatternX, Layout::stepPatternY,
					Layout::stepPatternSize, Layout::stepPatternRectsRatio, mng);
			stepPattern = pattern;
		}
	}
}

void StepPatternSelector::move(float mx, float my)
{
	stepPatternList->move(mx, my);
}


