/*
 * ParamMonitor.cpp
 *
 *  Created on: 2009/02/08
 *      Author: sambuichi
 */

#include "ParamMonitor.h"
#include "graphic/GlutMain.h"
#ifdef _FTGL_ENABLE_
#include "graphic/text/ftlabel.h"
#include "graphic/text/FTLabelFactory.h"
#endif

ParamMonitor::ParamMonitor(unsigned int row, UnitMng *mng) :
	row(row),
	rowCnt(0),
	createdRow(0),
	mng(mng)
{
	initRow(row);
}

ParamMonitor::~ParamMonitor() {
 	//! Delete param monitor labels
#ifdef _FTGL_ENABLE_
	int cnt = 0;
 	for(vector<ftlabel*>::iterator itr = paramMonitorLabels.begin(); itr != paramMonitorLabels.end(); itr++) {
 		((ftlabel*)*itr)->die();
 		cout << __FILE__ << " : erase param monitor label" << cnt++ << endl;
 	}
#endif
}

void ParamMonitor::initRow(unsigned int row)
{
	this->row = row;

#ifdef _FTGL_ENABLE_
	if(createdRow <= row) {
		for(; createdRow <= row; createdRow++) {
			ftlabel *ftl = FTLabelFactory::getInstance()->unitParamMonitorLabel(createdRow);
			paramMonitorLabels.push_back(ftl);
			mng->addUnit(ftl);
		}
	}
#endif
}

/*!
 * \brief xݒsJE^Zbg
 */
void ParamMonitor::labelStart() { rowCnt = 0; }

/*!
 * \brief sJE^CNg""݂̂̃xǉ
 * ̕ȗꍇ͋s
 */
void ParamMonitor::addLabel(string str)
{
#ifdef _FTGL_ENABLE_
	//! w肵s쐬ς݂Vector傫ꍇ͎Œǉ
	//	if(paramMonitorLabels.size() < row) {
	if(createdRow <= row) {
		initRow(rowCnt);
	}
	((ftlabel*)paramMonitorLabels.at(rowCnt++))->setLabel(str);
#endif
}

/*!
 * \brief sJE^CNg"{p[^"xǉ
 */
void ParamMonitor::addLabel(string label, float param)
{
	setLabel(label, param, rowCnt++);
}

/*!
 * \brief "{p[^"xw肵rowɐݒ
 * rowݕێlabels𒴂Ăꍇ͎Œǉ
 */
void ParamMonitor::setLabel(string label, float param, unsigned int row)
{
	ostringstream oss;

	//! w肵s쐬ς݂Vector傫ꍇ͎Œǉ
//	if(paramMonitorLabels.size() < row) {
	if(createdRow <= row) {
		initRow(row);
	}

	oss << label << setprecision(5) << param;
#ifdef _FTGL_ENABLE_
	((ftlabel*)paramMonitorLabels.at(row))->setLabel(oss.str());
#endif
}

void ParamMonitor::setActive(bool active)
{
	printfunc;

#ifdef _FTGL_ENABLE_
	if(active){
	 	for(vector<ftlabel*>::iterator itr = paramMonitorLabels.begin(); itr != paramMonitorLabels.end(); itr++) {
	 		((ftlabel*)*itr)->setActive(true);
	 	}
	} else {
	 	for(vector<ftlabel*>::iterator itr = paramMonitorLabels.begin(); itr != paramMonitorLabels.end(); itr++) {
	 		((ftlabel*)*itr)->setActive(false);
	 	}
	}
#endif
}
