/*
 * ConnectionConfig.cpp
 *
 *  Created on: 2009/02/18
 *      Author: sambuichi
 */

#include "ConnectionConfig.h"
#include "ctrl/GrPortList.h"
#include "ctrl/SyList.h"
#include "graphic/UnitGroup.h"

ConnectionConfig::ConnectionConfig(Unit *current) : FocusListener(false)
{
	DeclareName;
	printfunc;
	grlist = new GrPortList(current);
	sylist = new SyList();
	keyInputTarget = grlist;
	keyInputTarget->focusOn();
	keyInputTarget->setActive(true);
	//parent->pushCurrentStack(this); //! JgX^bNɂ
}

ConnectionConfig::~ConnectionConfig() {
	printfunc;
	parent->popCurrentStack(this);
	delete grlist;
	delete sylist;
}

void ConnectionConfig::setFocus(KeyInputListener *targetList)
{
	keyInputTarget->focusOff();
	keyInputTarget->setActive(false);
	keyInputTarget = targetList;
	keyInputTarget->focusOn();
	keyInputTarget->setActive(true);
}

void ConnectionConfig::keyFunc(int key, int action)
{
	printunitfunckey;
	if(action) {
		switch(key) {
		case GLFW_KEY_LEFT:
			setFocus(grlist);
			break;
		case GLFW_KEY_RIGHT:
			setFocus(sylist);
			break;
		default:
			keyInputTarget->keyFunc(key, action);
		}
	}
}

void ConnectionConfig::focusOn()
{
	coutline;
}

void ConnectionConfig::focusOff()
{
	coutline;
}
