/*
 * CtrlS.cpp
 *
 *  Created on: 2009/03/10
 *      Author: sambuichi
 */

#include "CtrlDemoMouseNoteOnA.h"
#include "graphic/GlutMain.h"
#include "graphic/updater/UpdaterKillUnit.h"

CtrlDemoMouseNoteOnA::CtrlDemoMouseNoteOnA() {
	DeclareName
	this->synth = MakeSynth("Moog", 4);
}

CtrlDemoMouseNoteOnA::~CtrlDemoMouseNoteOnA() {
	// TODO Auto-generated destructor stub
}

void CtrlDemoMouseNoteOnA::draw()
{
	if(!active) return;

	glEnable(GL_POLYGON_SMOOTH);

	lock();
	for(vector<Shape*>::iterator itr = begin(); itr < end(); itr++) {
		glPushMatrix();
		Shape *shape = (Shape*) *itr;
		shape->update();
		shape->draw();
		glPopMatrix();
	}
	unlock();

	loopend();
}

void CtrlDemoMouseNoteOnA::mouseFunction(int x, int y, int state)
{
	NoteOnCircle *circle = new NoteOnCircle(synth);
	circle->setSize(0.05);
	circle->setPos(x*width_over, y*height_over, 0.5);
	circle->setColor(1, 0.5 ,0.5 ,0.5);
//	addShape(circle);
	GlutMain::addUnit(circle);
	new UpdaterKillUnit(circle, 40);
}
