/*
 * DoublePendulum.cpp
 *
 *  Created on: 2009/03/24
 *      Author: sambuichi
 */

#include "DoublePendulum.h"

DoublePendulum::DoublePendulum() :
	m0(0.3),	// ̐Uq̎ [kg]
	m1(1.0),	// ̐Uq̎ [kg]
	l0(2.5),	// ̐Uq̒ [m]
	l1(4.0),	// ̐Uq̒ [m]
	g (9.8),	// d͉x [m/s^2]
	dt(0.05),
	tend(0.050),
	counter(0),
	t(0)
{
	x[0] = 1.0;
	x[1] = 0;
	x[2] = 0;
	x[3] = 0;
}

DoublePendulum::~DoublePendulum() {
	// TODO Auto-generated destructor stub
}

void DoublePendulum::next()
{
	Runge_Kutta_4(x);
	Draw_Pendulum(x);
}

/*======================================================================
    ֐ Runge_Kutta_4()
    ړIF4 Runge-Kutta @pĐϕ
======================================================================*/
void DoublePendulum::Runge_Kutta_4( //          | o
//     double *t      //       t  |   t+dt
    double y[]     // ֐l  y(t) | y(t+dt)
){
    int i;
    double f[N],y0[N],y1[N];

    for( i=0 ; i<N ; i++ ){
        y1[i]= y0[i] = y[i];
    }
    ODE_Def( y1 , f );
    for( i=0 ; i<N ; i++ ){
         y[i]=  y[i] + f[i]*dt/6. ;
        y1[i]= y0[i] + f[i]*dt/2. ;
    }
    ODE_Def( y1 , f );
    for( i=0 ; i<N ; i++ ){
         y[i]=  y[i] + f[i]*dt/3. ;
        y1[i]= y0[i] + f[i]*dt/2. ;
    }
    ODE_Def( y1 , f );
    for( i=0 ; i<N ; i++ ){
         y[i]=  y[i] + f[i]*dt/3. ;
        y1[i]= y0[i] + f[i]*dt    ;
    }
    ODE_Def( y1 , f );
    for( i=0 ; i<N ; i++ ){
         y[i]=  y[i] + f[i]*dt/6. ;
    }
//    *t= *t + dt ; /* i߂ */
}
/*======================================================================
    ֐ ODE_Def()
    ړIFdUq̉^ dx/dt = f(x,t)  f(x) ̌vZ
======================================================================*/
void DoublePendulum::ODE_Def(  /*             | o                   */
    double x[] /* xNg y ̒l | (͎̂܂)         */
   ,double f[] /* (s)          | Eӂ̃xNgf(y)̒l */
){
    double inertia[2][2],colioris[2],gravity[2];

    /* s */
    inertia[0][0]= (m0+m1)*l0*l0;
    inertia[0][1]= m1*l0*l1*cos(x[0]-x[1]);
    inertia[1][0]= m1*l0*l1*cos(x[0]-x[1]);
    inertia[1][1]= m1*l1*l1;
    Gyaku_Gyoretsu(inertia);/* s̋tšvZ */

    /* RI */
    colioris[0]=  m1*l0*l1*sin(x[0]-x[1])*x[3]*x[3];
    colioris[1]= -m1*l0*l1*sin(x[0]-x[1])*x[2]*x[2];

    /* d͍ */
    gravity[0]= (m0+m1)*l0*g*sin(x[0]);
    gravity[1]= m1*l1*g*sin(x[1]);

    /* dUq̔̉E */
    f[0]= x[2];
    f[1]= x[3];
    f[2]=   inertia[0][0]*(-colioris[0]-gravity[0])
          + inertia[0][1]*(-colioris[1]-gravity[1]);
    f[3]=   inertia[1][0]*(-colioris[0]-gravity[0])
          + inertia[1][1]*(-colioris[1]-gravity[1]);
}
/*======================================================================
    ֐ Gyaku_Gyoretsu()
    ړIF2~2s̋tšvZ
======================================================================*/
void DoublePendulum::Gyaku_Gyoretsu(
    double m[2][2]
){
    double det,a,b,c,d;
    a=m[0][0]; b=m[0][1]; c=m[1][0]; d=m[1][1]; det=a*d-b*c;
    m[0][0]=d/det; m[0][1]=-b/det; m[1][0]=-c/det; m[1][1]=a/det;
}

float DoublePendulum::getFirstRad()
{
	return x[0];
}

float DoublePendulum::secondRad()
{
	return x[1];
}

float DoublePendulum::firstAngleRate()
{
	return x[2];
}

float DoublePendulum::secondAngleRate()
{
	return x[3];
}

/*!
 * getPos() ʒusNZŎ擾
 */
int *DoublePendulum::getPos()
{
	return pos;
}


//	float firstRad;			// x[0]: ̐Uq̊px [rad]
//	float secondRad;		// x[1]: ̐Uq̊px [rad]
//	float firstAngleRate;	// x[2]: ̐Uq̊px [rad/s]
//	float secondAngleRate;	// x[3]: ̐Uq̊px [rad/s]

/*============================================================
    ֐ Draw_Pendulum()
    ړIFUq̊G`
    ϐF
    [A] t@C AnimationWindow.cpp Œ`Ă
        hdc_mem   nhfoCXReLXg
        hBlackPen ()ỹnh
    [B] ̃t@C(furiko.cpp)̏̕Œ`Ă
        l0, l1    Uq̒
        counter   ϕXebv
        dt        ϕ
        str       \p̕
    [C] ̊֐̋ߏŒ`Ă
        (lx0,ly0)  m0 ̈ʒu
        (lx1,ly1)  m1 ̈ʒu
============================================================*/
void DoublePendulum::Draw_Pendulum(
    double x[N]  // ݂̃R}̐Uq̑xApx
){

    // `̂߂̐Uq̐[̈ʒǔvZ
//    lx0= (int) ( l0*meter_to_pixel*sin(x[0]) );
//    ly0= (int) ( l0*meter_to_pixel*cos(x[0]) );
//    lx1= (int) ( l1*meter_to_pixel*sin(x[1]) );
//    ly1= (int) ( l1*meter_to_pixel*cos(x[1]) );
    pos[0]= (int) ( l0*meter_to_pixel*sin(x[0]) );
    pos[1]= (int) ( l0*meter_to_pixel*cos(x[0]) );
    pos[2]= (int) ( l1*meter_to_pixel*sin(x[1]) );
    pos[3]= (int) ( l1*meter_to_pixel*cos(x[1]) );

    // yŌ݂̎̐Uq`
//    SelectObject(hdc_mem,hBlackPen);
//    MoveToEx(hdc_mem,furiko_origin_x,furiko_origin_y,NULL);
//    LineTo(hdc_mem ,furiko_origin_x+lx0     ,furiko_origin_y+ly0     );
//    LineTo(hdc_mem ,furiko_origin_x+lx0+lx1 ,furiko_origin_y+ly0+ly1 );

//    // V~[Vł̎ t 𕶎 str ɏ
//    sprintf(str,"t=%7.3f",counter*dt);
//    // V~[Vł̎`
//    TextOut(hdc_mem,0,0,str,strlen(str));
}

