/*
 * MouseMonitor.cpp
 *
 *  Created on: 2009/02/08
 *      Author: sambuichi
 */

#include "MouseMonitor.h"
#include "graphic/text/ftlabel.h"
#include "graphic/text/FTLabelFactory.h"

MouseMonitor::MouseMonitor() {
	ftl = FTLabelFactory::getInstance()->mouseMonitorLabel("no input mouse");

	parent->addUnit(this);
	parent->addUnit(ftl);
}

MouseMonitor::~MouseMonitor() {
	parent->removeUnit(this);
	parent->removeUnit(ftl);
}

void MouseMonitor::update() {
	int x = MouseMng::getInstance()->X;
	int y = MouseMng::getInstance()->Y;

	ostringstream oss;
	oss << "mouse x=" << x << "  mosue y=" << y;

	ftl->setLabel(oss.str());
}

