/*
 * ShapePool.h
 *
 *  Created on: 2009/02/17
 *      Author: sambuichi
 */

#ifndef SHAPEPOOL_H_
#define SHAPEPOOL_H_

#include "graphic/primitive/Shape.h"

class ShapePool {
public:
	ShapePool();
	virtual ~ShapePool();

	void addShape(Shape *s);

	vector<Shape*>::iterator begin();
	vector<Shape*>::iterator end();

	void loopend();
	void lock();
	void unlock();

	int num_shape;
	float num_shape_over;

private:
	vector<Shape*> shapes;
	vector<Shape*> delayAddShapes;

	Mutex lc;
};

#endif /* SHAPEPOOL_H_ */
