#ifndef __GlutMAIN__
#define __GlutMAIN__

#include "GLUT/glut.h"
#include "common.h"
#include "graphic/AppForm.h"
#include "graphic/mng/AppMng.h"
#include "graphic/mng/UnitMng.h"
#include "graphic/mng/UpdaterMng.h"
#include "graphic/mng/WindowMng.h"

class Unit;
class Updater;

#define foreach_unitarray(func) \
	foreach_func(BaseUnit*, unitArray, func)

/*!
 * \brief GlutMain
 * Glut̏EX^[gEXgbv
 */
class GlutMain
{
public:
	static void Init();
	static void Start();
	static void Stop(void);
	static void update(void);
	static void draw(void);

	static void addApp(AppForm *app);
	static void addUnit(Unit *unit);
	static void addUpdater(Updater *up);

	static void addWindowListener(WindowListener *wl);

	static void setFramerate(double fps);
	static float getFramerate();
	static int timeToFrame(float time);

	static int width, height;

	static UnitMng *getUnitMng() { return unitMng; }

	static WindowMng *windowMng;

private:
	GlutMain(void) {};
	virtual ~GlutMain(void) {};

	static UpdaterMng *updaterMng;
	static UnitMng *unitMng;
	static AppMng *appMng;

	static int running;
	static double framerate;
	static double oneFrameTime;
	static double drawingRealTime;
};

#endif // __GlutMAIN__

