/*
 * GirdPositioner.cpp
 *
 *  Created on: 2009/09/05
 *      Author: samb
 */

#include "GirdPositioner.h"
#include "graphic/updater/UpdaterGrPort.h"
#include "graphic/GlutMain.h"

GridPositioner::GridPositioner(GridMaster &gm, UnitMng *mng) :
	gm(gm)
{
	printfunc
		
	//! Grid|WV
	rowLine = new Line();
	rowLine->setHeight(0);
	rowLine->setPos(0.5, (gm.numGridRow/2) * gm.gridHeight);

	rowLine->updateWidth(1.0, 10);
	mng->addUnit(rowLine);

	colLine = new Line();
	colLine->setWidth(0);
	colLine->setPos((gm.numGridCol/2) * gm.gridWidth, 0.5);
	colLine->updateHeight(1.0, 10);
	mng->addUnit(colLine);

	//! Grid|WVx
	rowLineLabel = FTLabelFactory::getInstance()->gridPositionLabel("row");
	rowLineLabel->setX(0.01);
	mng->addUnit(rowLineLabel);
	colLineLabel = FTLabelFactory::getInstance()->gridPositionLabel("col");
	colLineLabel->setY(0.04);
	mng->addUnit(colLineLabel);
}

GridPositioner::~GridPositioner() {
	// TODO Auto-generated destructor stub
}

//! Position that row, col Lines indexing (val 0.0~1.0)
void GridPositioner::position(float x, float y)
{
	// GridMasterGridɋzʒuo
	float mx = ((int)(x / gm.gridWidth)) * gm.gridWidth;
	float my = ((int)(y / gm.gridHeight)+1) * gm.gridHeight;

	// Row Col LinëʒuXV
	colLine->setX(mx);
	rowLine->setY(my);

	// Row Col LineẍʒuXV
	colLineLabel->setX(mx+0.005);
	rowLineLabel->setY(my-0.003);
}

