/*
 * GridFigure.cpp
 *
 *  Created on: 2009/08/31
 *      Author: sambuichi
 */

#include "GridFigure.h"
#include "graphic/updater/UpdaterKillUnit.h"
#include "graphic/updater/UpdaterGrPort.h"

/*!
 * GridMasterGrid\x[XɂGriď`쐬
 * x, y, ňʒuw肷i0~1KlGird̒lłȂĂ悢j
 */
GridFigureFactory::GridFigureFactory(GridMaster &gm, UnitMng *unitMng) :
	gm(gm), unitMng(unitMng)
{
	printfunc
	// x, yGirdzʒuɕ␳l
	gw = gm.gridWidth;
	gh = gm.gridHeight;
}

GridFigureFactory::~GridFigureFactory() {
	printfunc
}

//! Unito^
inline void GridFigureFactory::addParts(Unit *unit) {
	if(unitMng) {
		unitMng->addUnit(unit);
	} else {
		GlutMain::addUnit(unit);
	}
}

//! Line o^
inline void GridFigureFactory::addLine(Line *line) {
//	lines.push_back(line);
	addParts(line);
}

//! Rect o^
inline void GridFigureFactory::addRect(Rect *rect) {
//	rects.push_back(rect);
	addParts(rect);
}

//! x, y EGridWidth * num̒̐
inline Line *GridFigureFactory::gridRowLine(int cellX, int cellY, float num)
{
	Line *line = new Line();
	line->setAlign(SHAPE_CORNER_LEFT_TOP);
	line->setPos(cellX*gm.gridWidth+0.5, 0.5-cellY*gm.gridHeight);
	line->setWidth(num * gm.gridWidth);
	line->setHeight(0);
	addLine(line);
	return line;
}

//! x, y 牺GridHeight * num̒̐
inline Line *GridFigureFactory::gridColLine(int cellX, int cellY, float num)
{
	Line *line = new Line();
	line->setAlign(SHAPE_CORNER_LEFT_TOP);
	line->setPos(cellX*gm.gridWidth+0.5, 0.5-cellY*gm.gridHeight);
	line->setWidth(0);
	line->setHeight(num * gm.gridHeight);		// ! Wn͏vXCell͉vXȂ̂Ŕ]I
	addLine(line);
	return line;
}

////! cellX, cellY ƂCell̏ӂ`
//inline Line *GridFigureFactory::cellTopLine(float cellX, float cellY)
//{
//	return gridRowLine(cellX, cellY, 1);
//}
//
////! cellX, cellY ƂCell̍ӂ`
//inline Line *GridFigureFactory::cellLeftLine(float cellX, float cellY)
//{
//	return gridColLine(cellX, cellY, 1);
//}
//
////! cellX, cellY ƂCell̉Eӂ`
//inline Line *GridFigureFactory::cellRightLine(float cellX, float cellY)
//{
//	return gridColLine(cellX+1, cellY, 1);
//}
//
////! cellX, cellY ƂCell̉ӂ`
//inline Line *GridFigureFactory::cellBottomLine(float cellX, float cellY)
//{
//	return gridRowLine(cellX, cellY + 1, 1);
//}

//! cellX, cellY Ƃ``
inline Rect *GridFigureFactory::cellRect(int cellX, int cellY, float size, float alpha, bool fill)
{
	Rect *rect = new Rect();
	rect->setAlign(SHAPE_CORNER_LEFT_TOP);
	rect->setFill(fill);
	rect->setA(alpha);
	rect->setPos(cellX*gm.gridWidth+0.5, 0.5-cellY*gm.gridHeight);
	rect->setWidth(gm.gridWidth*size);
	rect->setHeight(gm.gridHeight*size);
	addRect(rect);
	return rect;
}

//! cellX, cellY 𒆐SƂ``
inline Rect *GridFigureFactory::cellRectCenter(int cellX, int cellY, float size, float alpha, bool fill)
{
	Rect *rect = new Rect();
	rect->setAlign(SHAPE_CENTER);
	rect->setFill(fill);
	rect->setA(alpha);
	rect->setPos((cellX+0.5)*gm.gridWidth+0.5, 0.5-(cellY+0.5)*gm.gridHeight);
	rect->setWidth(gm.gridWidth*size);
	rect->setHeight(gm.gridHeight*size);
	addRect(rect);
	return rect;
}

/*!
 * (cellX, cellY), (cellX2, cellY2) n_I_Ƃ``
 * n_ƏI_܂ރGA`悷
 */
inline Rect *GridFigureFactory::cellArea(int cellX, int cellY, int cellX2, int cellY2, float alpha, bool fill)
{
	Rect *rect = new Rect();
	rect->setFill(fill);
	rect->setA(alpha);

	rect->setAlign(SHAPE_CORNER_LEFT_TOP);
	float minx = (cellX >= cellX2) ? cellX2 : cellX;
	float maxx = (cellX <= cellX2) ? cellX2 : cellX;
	float miny = (cellY >= cellY2) ? cellY2 : cellY;
	float maxy = (cellY <= cellY2) ? cellY2 : cellY;
	rect->setPos(minx*gm.gridWidth+0.5, 0.5-(maxy+1)*gm.gridHeight);
	rect->setWidth(gm.gridWidth*(maxx-minx+1));
	rect->setHeight(gm.gridHeight*(maxy-miny+1));

	addRect(rect);

	rect->debugPrintPosition();
	return rect;
}



/////////////////////////////////
///---public




/*!
 * Draw Connection
 * Cell(x1, y1)Cell(x2, y2)ɌGridɉĐ
 */
GridFigureFactory::CellFigureHandle *GridFigureFactory::drawConnection(int cx1, int cy1, int cx2, int cy2)
{
	CellFigureHandle *handle = new CellFigureHandle();
	Line *rowLine = 0, *colLine = 0;

	cout << "  cx1=" << cx1;
	cout << "  cy1=" << cy1;
	cout << "  cx2=" << cx2;
	cout << "  cy2=" << cy2 << endl;

	if(cx1 < cx2) {
		if(cy1 < cy2) {
			int rowLength = cx2 - cx1 - 1;
			int colLength = cy2 - cy1 - 1;
			if(rowLength != 0) {
				handle->add(rowLine = gridRowLine(cx1+1, cy1+1, rowLength));
			}
			if(colLength != 0) {
				handle->add(colLine = gridColLine(cx1+1+rowLength, cy1+1, colLength));
			}
		} else {	//! cy1 >= cy2
			int rowLength = cx2 - cx1 - 1;
			int colLength = cy2 + 1 - cy1;
			if(rowLength != 0) {
				handle->add(rowLine = gridRowLine(cx1+1, cy1, rowLength));
			}
			if(colLength != 0) {
				handle->add(colLine = gridColLine(cx1+1+rowLength, cy1, colLength));
			}
		}
	} else {	// cx2 <= cx1
		if(cy1 < cy2) {
			int rowLength = cx2 - cx1 + 1;
			int colLength = cy2 - cy1 - 1;
			if(rowLength != 0) {
				handle->add(rowLine = gridRowLine(cx1, cy1+1, rowLength));
			}
			if(colLength != 0) {
				handle->add(colLine = gridColLine(cx1+rowLength, cy1+1, colLength));
			}
		} else {	//! cy1 >= cy2
			int rowLength = cx2 - cx1 + 1;
			int colLength = cy2 + 1 - cy1;
			if(rowLength != 0) {
				handle->add(rowLine = gridRowLine(cx1, cy1+colLength, rowLength));
			}
			if(colLength != 0) {
				handle->add(colLine = gridColLine(cx1, cy1, colLength));
			}
		}
	}

	addParts(handle);

	return handle;
}

/*!
 * Draw Connection
 * (x1, y1)(x2, y2)ɌGridɉĐ
 */
//GridFigureFactory::CellFigureHandle *GridFigureFactory::drawConnection(float x1, float y1, float x2, float y2)
//{
//	printfunc
//
//	int cx1 = (int)(x1 / gm.gridWidth);
//	int cy1 = (int)(y1 / gm.gridHeight);
//	int cx2 = (int)(x2 / gm.gridWidth);
//	int cy2 = (int)(y2 / gm.gridHeight);
//
//	CellFigureHandle *handle = drawConnection(cx1, cy1, cx2, cy2);
//
//	return handle;
//}



/*!
 * cellFigure type 1
 * w肵ʒui0~1lj؂̂ĂGridɋzCell`
 */
GridFigureFactory::CellFigureHandle *GridFigureFactory::drawCell(int col, int row, float size, float alpha, bool fill)
{
	CellFigureHandle *handle = new CellFigureHandle();

	handle->add(cellRectCenter(col, row, size, alpha, fill));

	addParts(handle);

	return handle;
}

/*!
 * cellFigure type 1
 * w肵ʒui0~1lj؂̂ĂGridɋzCell`
 */
GridFigureFactory::CellFigureHandle *GridFigureFactory::drawCell(float x, float y, float size, float alpha, bool fill)
{
	CellFigureHandle *handle = new CellFigureHandle();

	int cx = (int)(x / gm.gridWidth);
	int cy = (int)(y / gm.gridHeight);

	handle->add(cellRectCenter(cx, cy, size, alpha, fill));

	addParts(handle);

	return handle;
}

/*!
 * drawArea
 * w肵ʒui0~1lj؂̂ĂGridɋzRect`
 * (x1, y1), (x2, y2) n_I_Ƃ``
 * n_ƏI_܂ރGA`悷
 */
GridFigureFactory::CellFigureHandle *GridFigureFactory::drawArea(float x1, float y1, float x2, float y2, float alpha)
{
	printfunc
	CellFigureHandle *handle = new CellFigureHandle();

	int cx = (int)(x1 / gm.gridWidth);
	int cy = (int)(y1 / gm.gridHeight);
	int cx2 = (int)(x2 / gm.gridWidth);
	int cy2 = (int)(y2 / gm.gridHeight);

	handle->add(cellArea(cx, cy, cx2, cy2, alpha, true));

	addParts(handle);

	return handle;
}

/*!
 * drawArea : Zw
 * (cx1, cy1), (cx2, cy2) n_I_Ƃ``
 * n_ƏI_܂ރGA`悷
 */
GridFigureFactory::CellFigureHandle *GridFigureFactory::drawArea(int cx1, int cy1, int cx2, int cy2, float alpha)
{
	printfunc
	CellFigureHandle *handle = new CellFigureHandle();

	handle->add(cellArea(cx1, cy1, cx2, cy2, alpha, true));

	addParts(handle);

	return handle;
}





/*!
 * GridFigureFactory
 */
void GridFigureFactory::CellFigureHandle::setColor(float r, float g, float b, float a) {
	for(vector<Line*>::iterator itr = lines.begin(); itr != lines.end(); itr++) {
		((Line*)*itr)->setColor(r, g, b, a);
	}
	for(vector<Rect*>::iterator itr = rects.begin(); itr != rects.end(); itr++) {
		((Rect*)*itr)->setColor(r, g, b, a);
	}
}

void GridFigureFactory::CellFigureHandle::setColor(Colorful &color) {
	for(vector<Line*>::iterator itr = lines.begin(); itr != lines.end(); itr++) {
		((Line*)*itr)->setColor(color);
	}
	for(vector<Rect*>::iterator itr = rects.begin(); itr != rects.end(); itr++) {
		((Rect*)*itr)->setColor(color);
	}
}
