/*
 * GridFigure.h
 *
 *  Created on: 2009/08/31
 *      Author: sambuichi
 */

#ifndef GRIDFIGURE_H_
#define GRIDFIGURE_H_

#include "GridMaster.h"

#include "graphic/UnitForm.h"
#include "graphic/port/Colorful.h"
#include "graphic/primitive/Line.h"
#include "graphic/primitive/Rect.h"

/*!
 * GridMasterGridɂ킹`s
 * ̍Wwׂ͂0~1̐Klōs
 */
class GridFigureFactory {
public:
	GridFigureFactory(GridMaster &gm, UnitMng *unitMng = 0);
	virtual ~GridFigureFactory();

	//! cellFigurep̃nh
	struct CellFigureHandle : public UnitForm {
		CellFigureHandle() {}
		~CellFigureHandle() {
			for(vector<Line*>::iterator itr = lines.begin(); itr != lines.end(); itr++) {
				Line *line = (Line*) *itr;
				line->die();
			}
			for(vector<Rect*>::iterator itr = rects.begin(); itr != rects.end(); itr++) {
				Rect *rect = (Rect*) *itr;
				rect->die();
			}
		}
		void add(Line *line) {
			lines.push_back(line);
		}
		void add(Rect *rect) {
			rects.push_back(rect);
		}
		vector<Line*> lines;
		vector<Rect*> rects;

		void setColor(float r, float g, float b, float a);
		void setColor(Colorful &color);

		//! AlphalXV
		void updateAlpha(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
			for(vector<Line*>::iterator itr = lines.begin(); itr != lines.end(); itr++) {
				((Line*)*itr)->updateAlpha(startVal, endVal, startFrame, numFrame);
			}
			for(vector<Rect*>::iterator itr = rects.begin(); itr != rects.end(); itr++) {
				((Rect*)*itr)->updateAlpha(startVal, endVal, startFrame, numFrame);
			}
		}
	};

	CellFigureHandle *drawConnection(int cx1, int cy1, int cx2, int cy2);
//	CellFigureHandle *drawConnection(float x1, float y1, float x2, float y2);
	CellFigureHandle *drawCell(int col, int row, float size, float alpha, bool fill);
	CellFigureHandle *drawCell(float x, float y, float size, float alpha, bool fill);
	CellFigureHandle *drawArea(float x1, float y1, float x2, float y2, float alpha);
	CellFigureHandle *drawArea(int cx1, int cy1, int cx2, int cy2, float alpha);

private:
	GridMaster &gm;
	UnitMng *unitMng;
	float gw, gh;
	float width;
	float height;
//	float width_over;
//	float height_over;

	void addParts(Unit *unit);
	void addLine(Line *line);
	void addRect(Rect *rect);
	Line *gridRowLine(int cellX, int cellY, float num = 1);
	Line *gridColLine(int cellX, int cellY, float num = 1);

//	Line *cellTopLine(float cellX, float cellY);
//	Line *cellLeftLine(float cellX, float cellY);
//	Line *cellRightLine(float cellX, float cellY);
//	Line *cellBottomLine(float cellX, float cellY);

	Rect *cellRect(int cellX, int cellY, float size, float alpha, bool fill = true);
	Rect *cellRectCenter(int cellX, int cellY, float size, float alpha, bool fill = true);
	Rect *cellArea(int cellX, int cellY, int cellX2, int cellY2, float alpha, bool fill = true);
};

typedef GridFigureFactory::CellFigureHandle CellFigureHandle;

#endif /* GRIDFIGURE_H_ */
