/*
 * GridSheet.cpp
 *
 *  Created on: 2009/08/30
 *      Author: sambuichi
 */

#include "GridSheet.h"
#include "graphic/GlutMain.h"
#include "graphic/updater/UpdaterKillUnit.h"
#include "graphic/updater/UpdaterGrPort.h"

GridSheet::GridSheet(int row, int col, float width, float height, UnitMng *mng) :
	GridMaster(row, col),
	width(width), height(height),
	gridAlpha(0.2), mng(mng), drawing(false)
{
	printfunc
	drawSheet();
}

GridSheet::~GridSheet() {
	printfunc
	eraseSheet();
}

void GridSheet::eraseSheet()
{
	for(vector<Line*>::iterator itr = lines.begin(); itr != lines.end(); itr++) {
		Line *line = (Line*) *itr;
		line->updateAlpha(gridAlpha, 0, 0, 2);
		line->updateDelete(2);
	}
	lines.clear();
	drawing = false;
}

void GridSheet::drawSheet()
{
	printfunc
	if(drawing) {	// `ԂłȂ΁Aĕ`悷
		eraseSheet();
	}
	drawing = true;

	int startJit = 5;
	int countJit = 15;

	for(int i = 0; i < numGridRow; i++) {
		Line *line = addLine(0.5, gridHeight * i);
		int start = rand() % startJit;
		int count = rand() % countJit;
		line->updateWidth(0, 1.0, start, count);
		line->updateAlpha(0, gridAlpha, start, count);
	}
	for(int i = 0; i < numGridCol; i++) {
		Line *line = addLine(gridWidth * i, 0.5);
		int start = rand() % startJit;
		int count = rand() % countJit;
		line->updateHeight(0, 1.0, start, count);
		line->updateAlpha(0, gridAlpha, start, count);
	}
}

inline Line *GridSheet::addLine(float x, float y) {
	//cout << "GridSheet::addLine " << x << ", " << y << endl;
	Line *line = new Line();
	line->setWidth(0);
	line->setHeight(0);
	line->setA(0);
	line->setPos(x, y);
	mng->addUnit(line);
	lines.push_back(line);
	return line;
}

inline void GridSheet::drawSelectionSheet() {
	float gw = width * gridWidth;
	float gh = height * gridHeight;

	glColor3f(0.0, 1.0, 1.0);

	int numGridColH = numGridCol / 2;
	int numGridRowH = numGridRow / 2;
	for(int col = -numGridColH; col < numGridCol; col++) {
		glPushName(col);
		for(int row = -numGridRowH; row < numGridRow; row++) {
			glPushName(row);
			float x = col * gw;
			float y = row * gh;

			glBegin(GL_QUADS);
			glVertex3f(x, y, 0);
			glVertex3f(x+gw, y, 0);
			glVertex3f(x+gw, y+gh, 0);
			glVertex3f(x, y+gh, 0);
			glEnd();

			glPopName();
		}
		glPopName();
	}
}

#define BUFSIZE 1024

void GridSheet::mousePick(int x, int y, MousePick &mousePick)
{
	GLuint selectBuf[BUFSIZE];
	GLint hits;
	GLint viewport[4];
	float current_aspect;
	glGetIntegerv(GL_VIEWPORT, viewport);

	glSelectBuffer(BUFSIZE, selectBuf);
	(void) glRenderMode(GL_SELECT);

	glInitNames();
	glMatrixMode(GL_PROJECTION);			//vWFNV[h
	glPushMatrix();							//ZNV[ĥƂ̂݉̍svZ
	glLoadIdentity();					//𔽉f邽߂Push
	gluPickMatrix(x,viewport[3]-y,		//sbLOs̏Z
			1, 1, viewport);
	current_aspect = (float)viewport[2]/(float)viewport[3];
//	gluPerspective( 60.0, current_aspect, 1.0, 100.0 );
//	gluPerspective(45, current_aspect, -100.0, 100.0);
	gluPerspective(34.0, (double)width / (double)height, width/2, width*2);
	glMatrixMode( GL_MODELVIEW );		//Ńfr[[hɂIIII
	drawSelectionSheet();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();

	glMatrixMode( GL_MODELVIEW );			//fr[[h֖߂

	hits = glRenderMode(GL_RENDER);
	mousePick.SelectHits(hits, selectBuf);
}

void GridSheet::windowSizeChanged(int width, int height)
{
	this->width = width;
	this->height = height;
}

