/*
 * ListCtrl.cpp
 *
 *  Created on: 2009/11/01
 *      Author: ox
 */

#include "ListCtrl.h"

ListCtrl::ListCtrl(UnitMng *mng, float posx, float posy, float listHeight, int numShowItem) :
	mng(mng), posx(posx), posy(posy), listHeight(listHeight), numShowItem(numShowItem), currentPage(0),
	showing(false)
{
	itemHeight = listHeight / numShowItem;
	this->posy += itemHeight * 0.5;			// ͍ɂȂ̂
}

ListCtrl::~ListCtrl() {
}

int ListCtrl::select(int x, int y)
{
	if(showing) {
		for(unsigned int i = 0; i < itemVector.size(); i++) {
			if(itemVector.at(i)->select(x, y)) {	//
				return currentPage * numShowItem + i;
			}
		}
	}
	return -1;
}

void ListCtrl::position(int x, int y)
{
	if(showing) {
		for(unsigned int i = 0; i < itemVector.size(); i++) {
			itemVector.at(i)->position(x, y);
		}
	}
}

void ListCtrl::show(vector<string> listStrings)
{
	if(showing) {
		return;
	}

	this->showingStrings = listStrings;
	unsigned int pageItemIndexHead = 0;
	unsigned int pageItemIndexTail = 0;

	if(currentPage < 0) {
		currentPage = 0;
	}

	pageItemIndexHead = currentPage * numShowItem;
	while(pageItemIndexHead > listStrings.size()) {
		currentPage--;
		pageItemIndexHead = currentPage * numShowItem;
	}

	pageItemIndexTail = pageItemIndexHead + numShowItem;
	if(pageItemIndexTail > listStrings.size()) {
		pageItemIndexTail = listStrings.size();
	}

	itemMutex.lock();
	for(unsigned int i = pageItemIndexHead; i < pageItemIndexTail; i++) {
		float itemY = itemHeight * (i-pageItemIndexHead);
		ListItem *item = new ListItem(mng, listStrings.at(i), posx, posy + itemY, itemHeight);
		itemVector.push_back(item);
	}
	itemMutex.unlock();
	showing = true;
}

void ListCtrl::hide()
{
	itemMutex.lock();
	for(unsigned int i = 0; i < itemVector.size(); i++) {
		delete itemVector.at(i);
	}
	itemVector.clear();
	itemMutex.unlock();
	showing = false;
}

void ListCtrl::nextPage()
{
	if(showing) {
		currentPage++;
		hide();
		show(showingStrings);
	}
}

void ListCtrl::prevPage()
{
	if(showing) {
		currentPage--;
		hide();
		show(showingStrings);
	}
}

