/*
 * ListCtrl.h
 *
 *  Created on: 2009/11/01
 *      Author: ox
 */

#ifndef LISTCTRL_H_
#define LISTCTRL_H_

#include <vector>
#include "common/Mutex.h"
#include "graphic/mng/UnitMng.h"
#include "graphic/comp/ListItem.h"

using namespace stk;
using namespace std;

class ListCtrl {
public:
	ListCtrl(UnitMng *mng, float posx, float posy, float listHeight, int numShowItem);
	virtual ~ListCtrl();

	void show(vector<string> listStrings);
	void hide();

	int select(int x, int y);
	void position(int x, int y);

	bool isShowing() { return showing; }

	void nextPage();
	void prevPage();

private:
	UnitMng *mng;
	float posx, posy, listHeight;
	int numShowItem;
	int currentPage;
	float itemHeight;

	vector<ListItem*> itemVector;
	Mutex itemMutex;
	bool showing;
	vector<string> showingStrings;
};

#endif /* LISTCTRL_H_ */
