/*
 * ListItem.cpp
 *
 *  Created on: 2009/11/01
 *      Author: ox
 */

#include "ListItem.h"
#include "graphic/text/FTLabelFactory.h"

ListItem::ListItem(UnitMng *mng, string item, float posx, float posy, float size) :
	item(item), posx(posx), posy(posy), size(size), rollovering(false)
{
//	label = new ftlabel(item);
	label = FTLabelFactory::getInstance()->simpleLabel(item, posx, posy, size, 0.5, 0.5, 0.5);
	cout << posx << endl;
	cout << posy << endl;
	cout << size << endl;
//	label->setSize(size);
//	label->setPos(posx, posy, 0);
	mng->addUnit(label);
}

ListItem::~ListItem() {
	label->updateDelete(1);
}

void ListItem::position(int x, int y)
{
	if(rollovering) {				// [I[o
		if(!label->isArea(x, y)) {	// [I[oOꂽ
			rollovering = false;
			label->setA(0.5);
		}
	} else {						// [I[oĂȂ
		if(label->isArea(x, y)) {	// [I[o
			rollovering = true;
			label->setA(0.8);
		}
	}
}

bool ListItem::select(int x, int y)
{
	if(label->isArea(x, y)) {	// [I[o
		return true;
	}
	return false;
}

