/*
 * MousePick.cpp
 *
 *  Created on: 2009/11/15
 *      Author: ox
 */

#include "MousePick.h"

#define DEBUG_MOUSE_PICK

MousePick::MousePick() : numHitSum(0) {
}

MousePick::~MousePick() {
	// TODO Auto-generated destructor stub
}

void MousePick::clear()
{
	selectHits.clear();
}

int MousePick::size()
{
	return selectHits.size();
}

unsigned int MousePick::getHitNameDepth(unsigned int numHit)
{
	if(numHit < selectHits.size()) {
		return selectHits.at(numHit).nameDepth;
	}
	return 0;
}

unsigned int MousePick::getHitName(unsigned int numHit, unsigned int nameDepth)
{
	if(numHit < selectHits.size()) {
		return selectHits.at(numHit).hitName.at(nameDepth);
	}
	return 0;
}

int MousePick::SelectHits(GLuint hits,GLuint *buf) {
	unsigned int i,j;
	// őKw4Ɖ肵
	GLuint hit_name[4]={-1, -1, -1, -1};
	float depth_min=10.0f;
	float depth_1=1.0f;
	float depth_2=1.0f;
	GLuint depth_name;
	GLuint *ptr;
	// qbgf[^Ȃ
	if(hits<=0)return -1;
	// |C^Ɨpptr֓nD
	ptr = (GLuint*)buf;

	clear();

#ifdef DEBUG_MOUSE_PICK
	printf("Debug MousePick : num hits %d\n\n",(int)hits);
#endif
	numHitSum = hits;

	for(i=0; i<hits; i++){
		MousePick::SelectHit selectHit;

#ifdef DEBUG_MOUSE_PICK
		printf("  hit number : %d",(int)i+1);
#endif
		// ʔԍ̊Kw̐[
		depth_name = *ptr;
#ifdef DEBUG_MOUSE_PICK
		printf("  depth : %d\n",(int)depth_name); // ʔԍ̊Kw
#endif
		selectHit.nameDepth = depth_name;

		ptr++;
		depth_1 = (float) *ptr/0x7fffffff;
#ifdef DEBUG_MOUSE_PICK
		printf("    min depth : %f\n",depth_1); // fvX̍ŏl
#endif
		selectHit.minDepth = depth_1;

		ptr++;
		depth_2 = (float) *ptr/0x7fffffff;
		selectHit.maxDepth = depth_2;

		ptr++;
#ifdef DEBUG_MOUSE_PICK
#endif
		// ŏfvX̊mF
		if(depth_min>depth_1){
			depth_min = depth_1;
			// ʔԍۑ
			for(j=0; j<depth_name; j++){
#ifdef DEBUG_MOUSE_PICK
				printf("    pickup number : %d", *ptr); // ʔԍ
#endif
				hit_name[j] = *ptr;
				ptr++;
				selectHit.hitName.push_back(hit_name[j]);
			}
		}
		else{
			for(j=0; j<depth_name; j++){
#ifdef DEBUG_MOUSE_PICK
				printf("%d ",*ptr);
#endif
				ptr++;
				selectHit.hitName.push_back(hit_name[j]);
			}
		}

#ifdef DEBUG_MOUSE_PICK
		printf("\n");
#endif

		selectHits.push_back(selectHit);
	}
#ifdef DEBUG_MOUSE_PICK
	printf("\npickups\n"); // fvXŏ̎ʔԍ
#endif
	for(i=0;i<4;i++){
		if(hit_name[i]==-1)break;
#ifdef DEBUG_MOUSE_PICK
		printf("%d ",hit_name[i]);
#endif
	}
#ifdef DEBUG_MOUSE_PICK
	printf("\n\n\n");
#endif
	return 1;
}
