/*
 * VstiParamList.h
 *
 *  Created on: 2009/08/26
 *      Author: sambuichi
 */

#ifndef VSTIPARAMLIST_H_
#define VSTIPARAMLIST_H_

#include "common.h"
#include "sound/Synth.h"
#include "graphic/UnitForm.h"
#include "graphic/text/FTLabelFactory.h"
#include "graphic/primitive/Rect.h"

class VstiParamList : public UnitForm {
public:
	VstiParamList(Synth *synth, int selectedIndex = 0, int viewListLength = 10,
			float listPosx = 0.1, float listPosy = 0.1);
	virtual ~VstiParamList();

	void update();
	void draw();

	void next();
	void prev();

	int getSelectedIndex();

private:
	Synth *synth;
	int listRow;
	int listTopVectorIndex;
	int paramViewTopIndex;
	int labelMoveFrameCount;
	vector<ftlabel*> labels;
	float listTopY;
	float listRowHeight;
	float labelAlpha;
	float labelAlphaEmphasis;
	Rect *rect;

	typedef enum Direction {
		LabelNext,
		LabelPrev,
		LabelStop
	} Direction;

	typedef struct LabelItem {
		string label;
		Direction direct;
	} LabelItem;

	vector<LabelItem> queue;

	Direction moving;
	int movingCount;

	void moveSpeedAdjust();
	void prevLabelView(string labelString);
	void nextLabelView(string labelString);

};

#endif /* VSTIPARAMLIST_H_ */
