#include "FocusMng.h"
#include "../GlutMain.h"
#include <typeinfo>
#include "FocusChangedShowLabel.h"

FocusMng *FocusMng::instance = 0;

FocusMng::FocusMng(void)
{
	current = NULL; // debug 2008-06-15

	focusChangedShowLabel = new FocusChangedShowLabel();
	addFocusChangeListener(focusChangedShowLabel);
}

FocusMng *FocusMng::getInstance(void)
{
	if(FocusMng::instance == 0) {
		printfunc;
		FocusMng::instance = new FocusMng();
	}
	return FocusMng::instance;
}

void FocusMng::addFocusListener(FocusListener *l)
{
	focusListeners.push_back(l);
	current = l;
}

void FocusMng::printListeners()
{
	printfunc;
	for(vector<FocusListener*>::iterator itr = focusListeners.begin();
		itr != focusListeners.end(); itr++) {
		cout << "  " << typeid(*((FocusListener*)*itr)).name() << endl;
	}
}

FocusListener *FocusMng::getCurrent()
{
	return current;
}

void FocusMng::updateFocus()
{
	current->focusOn();
	current->setActive(true);
}

void FocusMng::nextFocus()
{
	printfunc;

	vector<FocusListener*>::iterator itr = focusListeners.begin();

	while(itr != focusListeners.end()) {
		if(current == (FocusListener *) *itr) {
			FocusListener *before = current;
			current->focusOff();
			current->setActive(false);
			itr++;
			if(itr != focusListeners.end()) {
				current = (FocusListener *) *itr;
			} else {
				current = (FocusListener *) *(focusListeners.begin());
			}
			current->focusOn();
			current->setActive(true);
			focusChangeProcedure(before, current);
			break;
		}
		itr++;
	}
}

void FocusMng::prevFocus()
{
	printfunc;

	vector<FocusListener*>::iterator itr = focusListeners.begin();

	FocusListener *prev = NULL;
	while(itr != focusListeners.end()) {
		if(current == (FocusListener *) *itr) {
			FocusListener *before = current;
			current->focusOff();
			current->setActive(false);
			if(prev == NULL) {
				current = (FocusListener *) *(focusListeners.rbegin());
			} else {
				current = prev;
			}
			current->focusOn();
			current->setActive(true);
			focusChangeProcedure(before, current);
			break;
		}
		prev = (FocusListener *) *itr;
		itr++;
	}
}

/*!
 * \brief tH[JXJڏ
 */
void FocusMng::focusChangeProcedure(FocusListener *beforeFocus, FocusListener *afterFocus)
{
	printfunc

	for(vector<FocusChangeListener*>::iterator itr = focusChangeListeners.begin();
		itr != focusChangeListeners.end(); itr++) {
		((FocusChangeListener*)*itr)->focusChanged(beforeFocus, afterFocus);
	}
}

/*!
 * \brief tH[JXJڏXi̓o^
 */
void FocusMng::addFocusChangeListener(FocusChangeListener *focusChangeListener)
{
	focusChangeListeners.push_back(focusChangeListener);
}
