#ifndef _FOCUSMNG_
#define _FOCUSMNG_

#include <string>
#include <map>
#include <vector>
#include <iostream>

#include "graphic/Unit.h"

using namespace std;

#define FOCUS_INPUT_KEY   1
#define FOCUS_INPUT_MOUSE 2

#define focusunit_typecheck_func(listener_type, func) \
	FocusListener *il = FocusMng::getInstance()->getCurrent(); \
	if(listener_type *l = dynamic_cast<listener_type*> (il)) { \
		l->func; \
	}

/*!
 * \brief FocusListener
 */
class FocusListener : public virtual Unit
{
public:
	FocusListener(bool ugf = true){};
	virtual ~FocusListener() {};
	virtual void focusOn() = 0;
	virtual void focusOff() = 0;
	virtual void setActive(bool active) {
		this->active = active;
	}
protected:
	bool active;
};

/*!
 * \brief FocusChangeListener
 * FocusMng̃tH[JXJڏʒm󂯎C^tF[X
 */
class FocusChangeListener
{
public:
	virtual void focusChanged(FocusListener *beforeFocus, FocusListener *afterFocus) = 0;
};

class FocusChangedShowLabel;

/*!
 * \brief FocusMng
 */
class FocusMng
{
private:
	FocusMng(void);
	static FocusMng *instance;		//! singleton
	FocusListener *current;   		//! current focus key_listener
	vector<FocusListener*> focusListeners;
	vector<FocusChangeListener*> focusChangeListeners;

	FocusChangedShowLabel *focusChangedShowLabel;

public:
	static FocusMng *getInstance(void);
	void addFocusListener(FocusListener *listener);
	void addFocusChangeListener(FocusChangeListener *focusChangeListener);
	void printListeners();
	void updateFocus();
	void nextFocus();
	void prevFocus();
	void focusChangeProcedure(FocusListener *beforeFocus, FocusListener *afterFocus);

	FocusListener *getCurrent();
};

#endif
