#ifndef _KEYLISTENER_
#define _KEYLISTENER_

#include <string>
#include <map>
#include <vector>
#include <iostream>
#include "FocusMng.h"

using namespace std;

#define KEY_PRESS      1
#define KEY_RELEASE    0

#define KEY_TAB        9
#define KEY_ENTER     13
#define KEY_ESC       27
#define KEY_SPACE     32

/* global key mapping macro */
#define KEYMAP_GLOBAL(key, kl) \
	keymng::getInstance()->global_keymapping(key, kl)

/* entry key listener macro */
/* #define KEY_ENTRY(listener) \ */
/* 	FocusMng::getInstance()->entry_listener(listener)  */

/* 	keymng::getInstance()->entry_listener(listener); \ */

/* special key hold macro */
#define KEYHOLD(name) \
	if( key == GLFW_KEY_##name ) { \
		name = action; \
	}

/* special key hold macro */
#define KEYHOLDLR(name) \
	if( key == GLFW_KEY_L##name || key == GLFW_KEY_R##name) { \
		name = action; \
	}

/* special key state macro */
#define KEY_SHIFT \
	KeyMng::getInstance()->SHIFT

/* special key state macro */
#define KEY_CTRL \
	KeyMng::getInstance()->CTRL

/* special key state macro */
#define KEY_ALT \
	KeyMng::getInstance()->ALT

#define KEY_EVENT_SUCCESS 0
#define NO_SUCH_KEYEVENT -1

/*!
 * key listener interface
 */
class KeyInputListener : public virtual FocusListener
{
public:
	virtual ~KeyInputListener() {};
	virtual void keyFunc(int key, int action) = 0;
};

/*!
 * key input management class
 */
class KeyMng
{
private:
	static KeyMng *instance; // singleton

	map<int, KeyInputListener*> global_map;

    KeyMng(void)
		: SHIFT(KEY_RELEASE), CTRL(KEY_RELEASE), ALT(KEY_RELEASE) {}

public:
	static KeyMng *getInstance(void);

	void global_keymapping(int key, KeyInputListener *kl);
	void print_key_map();
	void keyFunc(int key, int action);
	int SHIFT, CTRL, ALT;
};

#endif
