#include "MouseMng.h"
#include "../GlutMain.h"

MouseMng *MouseMng::instance = 0;

MouseMng::MouseMng(void)
{
	this->LEFT_BUTTON   = 0;
	this->RIGHT_BUTTON  = 0;
	this->MIDDLE_BUTTON = 0;
}

MouseMng *MouseMng::getInstance(void)
{
	if(MouseMng::instance == 0) {
		cout << "MouseMng : new instance()" << endl;
		MouseMng::instance = new MouseMng();
	}
	return MouseMng::instance;
}

void MouseMng::mouseFunction(int x, int y, int state)
{
	focusunit_typecheck_func(MouseListener, mouseFunction(x, y, state));
}

void MouseMng::mouseButton(int pos, int state)
{
 	cout << "[MouseMng] mouseButton pos:" << pos << "  state:" << state << endl;

	MOUSEHOLD(pos, state, LEFT);
	MOUSEHOLD(pos, state, RIGHT);
	MOUSEHOLD(pos, state, MIDDLE);

//	if(MOUSE_LDOWN) { // NbNōWʒm
	if(pos == GLUT_LEFT_BUTTON) { // NbNōWʒm
		mouseFunction(X, Y, state);
	}

	/* current focus unit [FocusMng]*/
	focusunit_typecheck_func(MouseListener, mouseButton(pos, state));
}

void MouseMng::mousePosition(int x, int y)
{
	//dbgout << "MouseMng::mousePosition()" << endl;
	X = x;
	Y = y;
 	focusunit_typecheck_func(MouseListener, mousePosition(x, y));
}

void MouseMng::mouseWheel(int val)
{
	WHEEL = val;
	focusunit_typecheck_func(MouseListener, mouseWheel(val));
}
