#ifndef _MOUSELISTENER_
#define _MOUSELISTENER_

#include <string>
#include <map>
#include <vector>
#include <iostream>
#include "FocusMng.h"

#include "graphic/Unit.h"

using namespace std;

/* special key hold macro */
#define MOUSEHOLD(pos, state, name) \
	if( pos == GLUT_##name##_BUTTON ) { \
		name##_BUTTON = state; \
	}

#define MOUSE_LDOWN \
	MouseMng::getInstance()->LEFT_BUTTON

#define MOUSE_RDOWN \
	MouseMng::getInstance()->RIGHT_BUTTON

#define MOUSE_MDOWN \
	MouseMng::getInstance()->MIDDLE_BUTTON

#define MOUSE_XPOS \
	MouseMng::getInstance()->X

#define MOUSE_YPOS \
	MouseMng::getInstance()->Y

#define MOUSE_WHEEL_VAL \
	MouseMng::getInstance()->WHEEL

/* mouse listener interface */
class MouseListener : public virtual FocusListener
{
public:
	virtual ~MouseListener() {};
	virtual void mouseFunction(int x, int y, int state){};
	virtual void mouseButton(int pos, int state){};
	virtual void mousePosition(int x, int y){};
	virtual void mouseWheel(int val){};
};

/* mouse input management class */
class MouseMng
{
private:
	static MouseMng *instance; // singleton
	MouseMng(void);
	map<int, MouseListener*> global_map;

public:
	static MouseMng *getInstance(void);

	void mouseFunction(int x, int y, int state);
	void mouseButton(int pos, int state);
	void mousePosition(int x, int y);
	void mouseWheel(int val);

	// }EX̏ԂێĂpublico
	int LEFT_BUTTON, RIGHT_BUTTON, MIDDLE_BUTTON;
	int X, Y, WHEEL;
};

#endif
