/*
 * Positionable.h
 *
 *  Created on: 2009/02/17
 *      Author: sambuichi
 */

#ifndef POSITIONABLE_H_
#define POSITIONABLE_H_

#include "PositionPort.h"
#include "graphic/DeadNotifier.h"
#include "graphic/updater/UpdaterGrPort.h"

class Positionable : public DeadNotifier {
public:
	Positionable(float posx = 0.5, float posy = 0.5, float posz = 0.5);
	virtual ~Positionable();

	void *setPos(const Positionable &positionable);

	void setPos(float posx, float posy, float z = 0.5);

	//! setter
	void setX(float posx);
	void setY(float posy);
	void setZ(float posz);

	//! getter
	float getX() const;
	float getY() const;
	float getZ() const;

	//! getter(Pixel Value)
	float getPixelX() const;
	float getPixelY() const;
	float getPixelZ() const;

	//! Updater
	void updateX(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new XPort(this), nx, endVal, 0, numFrame);
	}
	void updateX(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new XPort(this), startVal, endVal, startFrame, numFrame);
	}

	void updateY(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new YPort(this), ny, endVal, 0, numFrame);
	}
	void updateY(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new YPort(this), startVal, endVal, startFrame, numFrame);
	}

	void updateZ(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new ZPort(this), nz, endVal, 0, numFrame);
	}
	void updateZ(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new ZPort(this), startVal, endVal, startFrame, numFrame);
	}

	float distance(Positionable *p);

	void debugPrintPosition();

protected:
	/*!
	 * Pixel Value
	 */
	float pixelX, pixelY, pixelZ;

private:
	/*!
	 * Normalized(0~1) Value
	 */
	float nx, ny, nz;
};

#endif /* POSITIONABLE_H_ */
