#include "ftbuffer.h"
#include "meta-string.h"
#include "graphic/mng/KeyMng.h"
//#include "graphic/common/Window.h"
#include "graphic/GlutMain.h"

ftbuffer::ftbuffer(FTFont *font)
	: cursor(&str_head, font)
{
	this->font = font;
//	this->wnd = w;
	this->lineSpaceRatio = 1.15f;
	str_head = cursor.getStr();
	str_head->updateBB(font);
	setPos(0.05, 0.9);
}

void ftbuffer::draw()
{
	glPushMatrix();

	meta_string *mstr = str_head;
	mstr->updateBB(font);
	float xx = 0;
	float yy = -(mstr->getBBheight());
	float between_line = 0;

	while(mstr != NULL) {
		if(mstr->flag & METASTR_BREAK) {
			yy -= between_line * lineSpaceRatio;
			xx = 0;
		} else {
			glPushMatrix();
//			glRasterPos2f(xx-100, yy);
//			glTranslatef (xx, yy, 0.0);

			mstr->updateBB(font);
//			mstr->draw(font);
			glColor3f(mstr->red, mstr->green, mstr->blue);
			ftdrawstr2d(font, mstr->str.c_str(), x+xx, y+yy, ALIGN_LEFT);

			xx += mstr->getBBwidth();
			between_line = mstr->getBBheight();

			glPopMatrix();
		}

		mstr = mstr->next;
	}

	glPopMatrix();
}

int ftbuffer::keyin(unsigned int key)
{
//	meta_string *mstr = str_head;
	int ret = KEY_EVENT_SUCCESS;

	switch(key) {
	case KEY_SPACE:
		cursor.insert_delimiter(METASTR_SPACE);
		break;
	case KEY_ENTER:
		cursor.insert_delimiter(METASTR_BREAK);
		break;
	case GLUT_KEY_UP:
		//cursor.move_up();
		break;
	case GLUT_KEY_DOWN:
		//cursor.move_down();
		break;
	case GLUT_KEY_LEFT:
		cursor.move_left();
		break;
	case GLUT_KEY_RIGHT:
		cursor.move_right();
		break;
	default:
#if 0
		if(key < GLFW_KEY_SPECIAL) {
			cursor += (char) (key+32);
		} else {
			ret = NO_SUCH_KEYEVENT;
		}
#else
		cursor += (char) (key+32);
#endif
		break;
	}

	return ret;
}

/*!
 * \brief x̕`Wlݒ
 * !! ʒu͉ʍ̑Έʒu0~1̐KꂽlŎw肷
 */
void ftbuffer::setPos(float posx, float posy)
{
	float fw = GlutMain::width;
	float fh = GlutMain::height;

//	this->x = -fw/2 + (fw * posx);
//	this->y =  fh/2 - (fh * posy);
	this->x = (fw * posx);
	this->y = (fh * posy);
}

void ftbuffer::debug_print_buffer()
{
	std::cout << "+ ftbuffer::debug_print_buffer" << std::endl;

	meta_string *mstr = str_head;
	unsigned int cnt = 0;
	while(mstr != NULL) {
		if(cnt == cursor.current_nr()) {
			cout << "current => ";
		}
		cout << cnt++ << " : ";
		mstr->debug_print_mstr();
		mstr = mstr->next;
	}
}

//void ftbuffer::setWindow(Window *wnd)
//{
//	this->wnd = wnd;
//}

void ftbuffer::setLineSpaceRatio(float ratio)
{
	this->lineSpaceRatio = ratio;
}


