#include "ftcursor.h"

void ftcursor::operator+=(char c)
{
	*current += c;
	index++;
}

void ftcursor::move_right()
{
	if(index == current->length()) {
		next_word();
	} else {
		index++;
	}
}

void ftcursor::next_word()
{
	if(current->next == NULL) {
		return;
	} else {
		current = current->next;
		str_nr++;
		index = 0;
	}
}

void ftcursor::move_left()
{
	if(index == 0) {
		prev_word();
	} else {
		index--;
	}
}

void ftcursor::prev_word()
{
	if(current->prev == NULL) {
		return;
	} else {
		current = current->prev;
		str_nr--;
		if(current->length() == 0) {
			index = 0;
		} else {
			index = current->length() - 1;
		}
	}
}

void ftcursor::insert_delimiter(unsigned int delimiter_desc)
{
	meta_string *delimiter = new meta_string(delimiter_desc);

	if(current->length() == 0) { // empty
		cout << "insert delimiter before current" << endl;
		if(current->prev != NULL) {
			delimiter->prev = current->prev;
			current->prev->next = delimiter;
		} else {
			*hob = delimiter; // reset buffer headstr
		}
		delimiter->next = current;
		current->prev = delimiter;
		str_nr++;
		return;
	}

	if(index == current->length()) { // cursor is last index position of current meta-string
		meta_string *new_str;
		if(current->next == NULL) {
			new_str = new meta_string("");
		} else {
			new_str = current->next;
		}
		linkstr(current, delimiter);
		linkstr(delimiter, new_str);
		current = new_str;
		str_nr += 2;
		index = 0;
	} else if(index == 0) { // cursor is head og current meta-string
		if(current->prev == NULL) {
			linkstr(delimiter, current);
			*hob = delimiter; // reset buffer headstr
		} else {
			meta_string *prev_str = current->prev;
			linkstr(prev_str, delimiter);
			linkstr(delimiter, current);
		}
		str_nr++;
	} else if(index < current->length()) {
		meta_string *next_str = new meta_string("");
		meta_string *prev_str = current;
		*next_str = *current; // clone
		prev_str->substr(0, index);
		next_str->substr(index);
		linkstr(prev_str, delimiter);
		linkstr(delimiter, next_str);
		current = next_str;
		str_nr += 2;
		index = 0;
	} else {
		// exception
	}
}

meta_string *ftcursor::getStr()
{
	return current;
}

unsigned int ftcursor::current_nr()
{
	return str_nr;
}


