/*
 * UpdaterGrPort.cpp
 *
 *  Created on: 2009/03/20
 *      Author: sambuichi
 */

#include "UpdaterGrPort.h"
#include "graphic/port/GrPort.h"

/*!
 * Updater for GrPort
 */
UpdaterGrPort::UpdaterGrPort(GrPort *port, float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) :
	startVal(startVal),
	endVal(endVal),
	currentFrame(0),
	startFrame(startFrame),
	numFrame(numFrame)
{
	this->port = port;
	port->addDeadListener(this);
}

UpdaterGrPort::~UpdaterGrPort()
{
//	printfunc
	//! Port͎ĝĂ̈ƂUpdaterƈꏏɍ폜
	// BUG!!!
//	delete port;
}

/*!
 * Updater̒lωݒ
 */
void UpdaterGrPort::set(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame)
{
	this->startVal = startVal;
	this->endVal = endVal;
	this->numFrame = numFrame;
	this->startFrame = startFrame;
}

/*!
 * ^[QbgE|[g̒lXV
 */
void UpdaterGrPort::update()
{
	if(startFrame <= 0) {
		float stepVal = (endVal - startVal) / (float)numFrame;
		float val = startVal + (stepVal * currentFrame);
		port->set(val);

		currentFrame++;

//		printfunc;

		if(currentFrame >= numFrame) {
			port->set(endVal);
			port->removeDeadListener(this);
			die();
		}
	} else {
		startFrame--;
	}
}

//void UpdaterGrPort::die()
//{
//	dead = true;
//}
