#ifndef _SORT_MESSAGER_
#define _SORT_MESSAGER_

#include "Stk.h"
#include "Skini.h"
#include "RtAudio.h"
#include "SKINI.msg"
#include "Mutex.h"
#include "common.h"

namespace stk {

class SortMessager : public Stk
{

public:
	SortMessager();
	~SortMessager();

	void popMessage( Skini::Message& message );
	void pop();

	Skini::Message &pushMessage( Skini::Message& message );

	void frontMessage( Skini::Message& message );

	Mutex mutex;

	class MessageSortQueue {
	protected:
		std::vector<Skini::Message> c;

		bool compare (Skini::Message &se1, Skini::Message &se2) const {
#ifdef __RTSTK_MSGTIME_INT__
			return se1.intValues[SKINI_MSG_INT_TICKTIME] > se2.intValues[SKINI_MSG_INT_TICKTIME];
#else
			return se1.time > se2.time;
#endif
		}

	public:
		typedef std::vector<Skini::Message>::size_type size_type;

		MessageSortQueue() {};

		bool empty() const { return c.empty(); }
		size_type size() const { return c.size(); }
		Skini::Message top() const { return c.back(); }
		void pop() { c.pop_back(); }

		Skini::Message &push( Skini::Message &se) {
			std::vector<Skini::Message>::iterator it = c.begin();
			while( it != c.end() && compare(*it, se) ) ++it;
			return *(c.insert(it, se));
		}
	};

	MessageSortQueue queue;

};

}

#endif
