/*
 * Stki.cpp
 *
 *  Created on: 2009/08/20
 *      Author: sambuichi
 */
#include <string.h>
#include "common.h"
#include "Synth.h"
#include "Stki.h"
#include "Instrmnt.h"
#include "SKINI.msg"
#include "Skini.h"

#include "Clarinet.h"
#include "BlowHole.h"
#include "Saxofony.h"
#include "Flute.h"
#include "Brass.h"
#include "BlowBotl.h"
#include "Bowed.h"
#include "Plucked.h"
#include "StifKarp.h"
#include "Sitar.h"
#include "Mandolin.h"
#include "Rhodey.h"
#include "Wurley.h"
#include "TubeBell.h"
#include "HevyMetl.h"
#include "PercFlut.h"
#include "BeeThree.h"
#include "FMVoices.h"
#include "VoicForm.h"
#include "Moog.h"
#include "Simple.h"
#include "Drummer.h"
#include "BandedWG.h"
#include "Shakers.h"
#include "ModalBar.h"
#include "Mesh2D.h"
#include "Resonate.h"
#include "Whistle.h"

using namespace stk;

char Stki::stkInstNames[NUM_INSTS][10] = {
	"Clarinet", "BlowHole", "Saxofony", "Flute", "Brass",
	"BlowBotl", "Bowed", "Plucked", "StifKarp", "Sitar",
	"Mandolin",	"Rhodey", "Wurley", "TubeBell", "HevyMetl",
	"PercFlut",	"BeeThree", "FMVoices", "VoicForm", "Moog",
	"Simple", "Drummer", "BandedWG", "Shakers", "ModalBar",
	"Mesh2D", "Resonate", "Whistle" };

map<int, long> Stki::idToTagMap;	// bZ[WIDƃm[gԍ̑ΉMAPiNoteOn/OFFpj

Stki::Stki(string name) {
	setName(name);
}

Stki::~Stki() {
}

void Stki::setProgram(int programNumber)
{

}

void Stki::setInstruments(int instNum, int numVoice)
{
	for(int i = 0; i < numVoice; i++) {
		Instrmnt *in = instByNumber(instNum);
		if(in == NULL) {
			printf("error: Stki no such instrument");
//			delete stki;
//			stki = NULL;
//			return NULL;	// Instrmnt̍쐬łȂ̂ŃG[
			return;
		}
		insts.push_back(in);
		voicer.addInstrument(in);
	}
}

Instrmnt *Stki::instByName(char *name)
{
	int i = 0, notFound = 1;
	Instrmnt *instrument = NULL;

	while ( i < NUM_INSTS && notFound ) {
		if ( !strcmp(name, stkInstNames[i]) ) {
			notFound = 0;
			instrument = instByNumber(i);
		}
		i++;
	}

	if (notFound)
		printf("\nUnknown instrument or program change requested!\n");

	return instrument;
}

Instrmnt *Stki::instByNumber(int number)
{
	Instrmnt *instrument = NULL;

	if     (number==0)  instrument = new Clarinet(10.0);
	else if (number==1)  instrument = new BlowHole(10.0);
	else if (number==2)  instrument = new Saxofony(10.0);
	else if (number==3)  instrument = new Flute(10.0);
	else if (number==4)  instrument = new Brass(10.0);
	else if (number==5)  instrument = new BlowBotl();
	else if (number==6)  instrument = new Bowed(10.0);
	else if (number==7)  instrument = new Plucked(5.0);
	else if (number==8)  instrument = new StifKarp(5.0);
	else if (number==9)  instrument = new Sitar(5.0);
	else if (number==10) instrument = new Mandolin(5.0);

	else if (number==11) instrument = new Rhodey;
	else if (number==12) instrument = new Wurley;
	else if (number==13) instrument = new TubeBell;
	else if (number==14) instrument = new HevyMetl();
	else if (number==15) instrument = new PercFlut();
	else if (number==16) instrument = new BeeThree;
	else if (number==17) instrument = new FMVoices;

	else if (number==18) instrument = new VoicForm();
	else if (number==19) instrument = new Moog();
	else if (number==20) instrument = new Simple();
	else if (number==21) instrument = new Drummer();
	else if (number==22) instrument = new BandedWG();
	else if (number==23) instrument = new Shakers();
	else if (number==24) instrument = new ModalBar();
	else if (number==25) instrument = new Mesh2D(10, 10);
	else if (number==26) instrument = new Resonate();
	else if (number==27) instrument = new Whistle();

	else {
		printf("\nUnknown instrument or program change requested!\n");
		return NULL;
	}

	return instrument;
}

/*!
 * nameŎw肵StkInst̔ԍԂ
 */
int Stki::getStkInstNumber(const char *name)
{
	int i = 0;

	while (i < NUM_INSTS) {
		if ( !strcmp(name, stkInstNames[i]) ) {
			return i;
		}
		i++;
	}

	return -1;
}

char *Stki::getStkInstName(int num)
{
	if(num < NUM_INSTS) {
		return stkInstNames[num];
	}
	return NO_STK_INST_NAME;
}

/*!
 * STK SynthԍSynth擾
 */
char *Stki::instNum2Str(int inst_num)
{
	if(inst_num < NUM_INSTS) {
		return stkInstNames[inst_num];
	}
	return 0;
}

float Stki::tick()
{
	return voicer.tick();
}

float Stki::tick(float **buffer, unsigned int channel, unsigned int num)
{
//	return voicer.tick();
	for(unsigned int i = 0; i < num; i++) {
		float val = voicer.tick();
		for(unsigned int ch = 0; ch < channel; ch++) {
//			buffer[ch][num] = voicer.tick(ch);
			buffer[ch][num] = val;
		}
	}
	return 0;
}


void Stki::processMessage(Skini::Message &message)
{
	printfunc

	register StkFloat value1 = message.floatValues[0];
	register StkFloat value2 = message.floatValues[1];
	long tag;
	int voicer_channel = 0; // debug 20090712

	switch( message.type ) {
	case __SK_NoteOnTag_:
		tag = voicer.noteOn( value1, value2, voicer_channel );
		mapIDToTag(message.intValues.at(0), tag);
		break;
	case __SK_NoteOffTag_:
		tag = getTagFromID(message.intValues.at(0));
//		tag = NoteTag::getInstance()->getValue(message.intValues[SKINI_MSG_INT_NOTETAG]);
		voicer.noteOff( tag, 0 );
		break;
	case __SK_NoteOn_:
		if ( value2 == 0.0 ) // velocity is zero ... really a NoteOff
			voicer.noteOff( value1, 64.0, voicer_channel );
		else // a NoteOn
			voicer.noteOn( value1, value2, voicer_channel );
		break;
	case __SK_NoteOff_:
		voicer.noteOff( value1, value2, voicer_channel );
		break;
	case __SK_ControlChange_:
		if (value1 == 44.0)
			break;
		else if (value1 == 49.0)
			voicer.setFrequency( value2, voicer_channel );
		else if (value1 == 50.0)
			voicer.controlChange( 128, value2, voicer_channel );
		else
			voicer.controlChange( (int) value1, value2, voicer_channel );
		break;
	case __SK_AfterTouch_:
		voicer.controlChange( 128, value1, voicer_channel );
		break;
	case __SK_PitchChange_:
		voicer.setFrequency( value1, voicer_channel );
		break;
	case __SK_PitchBend_:
		short temp;
		temp = message.intValues[1] << 7;
		temp += message.intValues[0];
		voicer.pitchBend( (StkFloat) temp, voicer_channel );
		break;
	case __SK_Volume_:
		volume = value1 * ONE_OVER_128;
		break;
	}
}

//! Sequence static func
void Stki::mapIDToTag(int id, long tag) {
	idToTagMap.insert(map<int,long>::value_type(id, tag));
}

//! Sequence static func
long Stki::getTagFromID(int id) {
	map<int,long>::iterator itr = idToTagMap.find(id);
	if( itr != idToTagMap.end() ) {
		if(itr->second) {
			long value = itr->second;
			idToTagMap.erase(itr);
			return value;
		}
	}
	return 0;
}

