#include "common.h"
#include "RtStk.h"
#include "SynthFactory.h"
#include "Sequence.h"
#include "Arpeggiator.h"

#ifdef VST_ENABLE
#include "CVSTHost.h"
#include "Vsti.h"
#include "VstiDir.h"
CVSTHost vsthost;
#endif

static RtStk *rts = NULL;

void sound_main(int argc, char *argv[])
{
	if(rts == NULL)
	{
		rts = RtStk::getInstance();
	}

	rts->metro.setTempo(120);

	//! debug 20090820 : SynthFormのインスタンス作成よりも前にopenDacしとく
	rts->openDac();

//	string vstiname = "C:/Program Files/Steinberg/VstPlugins/Pro-53.dll";
//	string vstiname = "C:/eclipse-ganymede/workspace/vstsynth/デバッグ/libvstsynth.dll";
//	string vstiname = "MS-20.dll";
//	string vstiname = "Polysix.dll";
//	string vstiname = "GTG_ST_2008.dll";
//	string vstiname = "SB-3 LE.dll";
//	string vstiname = "Synth1 VST.dll";
//	string vstiname = "VstJuno6.dll";
//	string vstiname = "Crystal.dll";
//	string vstiname = "Moog";
}

void sound_start()
{
	#ifdef VST_ENABLE
	vsthost.SetSampleRate(rts->getSamplingRate());
	vsthost.SetBlockSize(rts->getBufferFrames());
	#endif

	rts->startDac();
}

void sound_release()
{
	rts->closeDac();
	delete rts;
}
