//
//  GrMain.h
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/19.
//
//

#ifndef __myNewApp__GrMain__
#define __myNewApp__GrMain__

#include "ofMain.h"
#include <math.h>

class GrBase
{
public:
    GrBase() {
		this->id = idCounter++;
	}
    virtual ~GrBase() {};
//protected:
    int id;
	
private:
    static int idCounter;
};

//--------------------------------------------------------------
class GrDrawer : public virtual GrBase {
public:
    virtual void draw() = 0;
};

class GrUpdater : public virtual GrBase {
public:
GrUpdater() : aliveCnt(1) {}
	
    virtual void update() = 0;
	
	int getAliveCnt() { return aliveCnt; }
	
protected:
	int aliveCnt;
};

class GrMouse : public virtual GrBase
{
public:
	virtual void mouseMoved(int x, int y );
	virtual void mouseDragged(int x, int y, int button);
	virtual void mousePressed(int x, int y, int button);
	virtual void mouseReleased(int x, int y, int button);

	/* static int mouseMoveX, mouseMoveY; */
	/* static int mouseDragX, mouseDragY; */
	/* static int mousePressX, mousePressY; */
	/* static int mouseReleaseX, mouseReleaseY; */
};

//--------------------------------------------------------------
class GrMain : public GrDrawer, GrUpdater, GrMouse {
private:
    std::vector<ofPtr<GrBase> > mGrBase;
    std::vector<GrUpdater*> mGrUpdates;
    std::vector<GrDrawer*> mGrDraws;
    std::vector<GrMouse*> mGrMouses;
    std::vector<GrBase*> mPreAddMember;
    std::vector<GrBase*> mPreRemoveMember;
	
    void removeMemberImpl(GrBase *grBase);
    void addMemberImpl(GrBase *grBase);
    ofMutex mPreAddLock;

public:
    GrMain();
	virtual ~GrMain();
	
	/* -- Updater -- */
    void update();
	
	/* -- Drawer -- */
    void draw();

	/* -- Mouse -- */
	void mouseMoved(int x, int y );
	void mouseDragged(int x, int y, int button);
	void mousePressed(int x, int y, int button);
	void mouseReleased(int x, int y, int button);

    void add(GrBase *grBase);
	void remove(GrBase *grBase);
	void remove(GrBase *grBase, int delay);
};

inline double grDistance(int srcX, int srcY, int destX, int destY) {
	return sqrt(((srcX - destX) * (srcX - destX)) + ((srcY - destY) * (srcY - destY)));
}

#endif /* defined(__myNewApp__GrMain__) */
