#include "PDrawIf.h"
#include "PDraw.h"
#include "GrColors.h"

using namespace psig;

/**
 * @brief createRectMove
 * @description rect & move
 * @note global function
 */
GrMain *createRectMove(float x, float y, float mx, float my, float sx, float sy)
{
	PRect *rect = new PRect(20, 20);
	
	PDraw *pdraw = new PDraw(rect);
	pdraw->addStyle(new PPos(ofGetWidth()>>1, ofGetHeight()>>1));
	pdraw->addStyle(new PPos(new PCnt(0, x, x+mx),
							 new PCnt(0, y, y+my)));
	pdraw->addStyle(new PColor(colorSet[COLOR_COOL_4C_DARK_BLUE]));
	
	GrMain *gm = new GrMain();
	gm->add(pdraw);
	return gm;
}

/**
 * @brief createRectMoveCircle
 * @description complex rect & move structure test
 * @note global function
 */
GrMain *createRectMoveCircle(float x, float y, float w, float h, int num)
{
	GrMain *gm = new GrMain();

	for(int i = 0; i < num; i++) {
		PRect *rect = new PRect(20, 20);
		PDraw *pdraw = new PDraw(rect);
		pdraw->addStyle(new PPos(ofGetWidth()>>1, ofGetHeight()>>1));
		pdraw->addStyle(new PPos(new PAdd(new PInput(&psig::mousePressX),
										  new PMlt(w, new PSin(1/100.0, 0    + i * 0.1))),
								 new PAdd(new PInput(&psig::mousePressY),
										  new PMlt(h, new PSin(1/90.0, 0.25 + i * 0.1)))));
		pdraw->addStyle(new PColor(colorSet[COLOR_COOL_4C_DARK_BLUE]));
		gm->add(pdraw);
	}
	
	return gm;
}

/**
 * @brief createRectMoveArray
 * @description complex rect & move structure test
 * @note global function
 */
GrMain *createRectMoveArray(float x, float y, float w, float h, int num)
{
	GrMain *gm = new GrMain();
	double ww = w / (double)num;

	for(int i = 0; i < num; i++) {
		PRect *rect = new PRect();
		PDraw *pdraw = new PDraw(rect);
		pdraw->addStyle(new PPos(ofGetWidth()>>1, ofGetHeight()>>1));
		pdraw->addStyle(new PPos(new PCntd(x, x + w, 20, x + i * ww),
								 new PInput(&psig::mouseDragY)));
		pdraw->addStyle(new PColor(colorSet[COLOR_COOL_4C_GREEN]));
		gm->add(pdraw);
	}
	
	return gm;
}

GrMain *createRectCircleSeq001(float x, float y, float w, float h)
{
	PArc *arc = new PArc();
	arc->num = 100;
	arc->w = 100;
	arc->h = 100;
	arc->weight = 0.3;
	arc->radS = new PMlt(new PInput(&psig::mouseDragX), 1.0/ofGetWidth());
	arc->radE = new PMlt(new PInput(&psig::mouseDragY), 1.0/ofGetHeight());
	
	PDraw *pdraw = new PDraw(arc);
	pdraw->addStyle(new PPos(ofGetWidth()>>1, ofGetHeight()>>1));
	pdraw->addStyle(new PColor(colorSet[COLOR_COOL_2C_PURPLE]));
	
	GrMain *gm = new GrMain();
	gm->add(pdraw);
	return gm;
}


/**
 * @brief createCircle
 * @description draw circle
 * @note global function
 */
GrMain *createCircle(float x, float y, float w, float h)
{
	PCircle *cr = new PCircle();
	cr->w = 100;
	cr->h = 100;
	cr->num = new PCntd(10, 50, 40);
	
	PDraw *pdraw = new PDraw(cr);
	pdraw->addStyle(new PPos(ofGetWidth()>>1, ofGetHeight()>>1));
	pdraw->addStyle(new PColor(colorSet[COLOR_COOL_4C_PURPLE]));
	
	GrMain *gm = new GrMain();
	gm->add(pdraw);
	return gm;
}

/**
 * @brief createRing
 * @description draw ring
 * @note global function
 */
GrMain *createRing(float x, float y, float w, float h, float weight)
{
	PRing *ring = new PRing(100.0, 30.0, new PCntd(weight, 0.5, 20), 100);
	
	PDraw *pdraw = new PDraw(ring);
	pdraw->addStyle(new PPos(ofGetWidth()>>1, ofGetHeight()>>1));
	pdraw->addStyle(new PColor(colorSet[COLOR_COOL_2C_PURPLE]));
	
	GrMain *gm = new GrMain();
	gm->add(pdraw);
	return gm;
}

/**
 * @brief createRing
 * @description draw ring
 * @note global function
 */
GrMain *createRingRect(float x, float y, float w, float h, float weight)
{
	PRingRect *ring = new PRingRect(w, h, new PCntd(weight, 0.5, 20));
	
	PDraw *pdraw = new PDraw(ring);
	pdraw->addStyle(new PPos(x, y));
	pdraw->addStyle(new PPos(ofGetWidth()>>1, ofGetHeight()>>1));
	pdraw->addStyle(new PColor(colorSet[COLOR_COOL_2C_GREEN]));
	
	GrMain *gm = new GrMain();
	gm->add(pdraw);
	return gm;
}

GrMain *createPDrawTest_001()
{
	double w = ofGetWidth();
	double h = ofGetHeight();
	int numCol = 5;

	double hh = h * 0.5 / (numCol * 2);

	GrMain *gm = new GrMain();
	
	for(int i = 0; i < numCol; i++) {
		PRect *rect = new PRect(new PCnt(0, 0, (int)(w * 0.8), 1), hh);
		PDraw *pdraw = new PDraw(rect);
		pdraw->addStyle(new PPos(0.0, h * 0.25));
		pdraw->addStyle(new PPos(w * 0.1, hh * 2 * i));
		pdraw->addStyle(new PColor(colorSet[COLOR_COOL_4C_QUIET_BLUE1 + i]));

		gm->add(pdraw);
	}
	
	return gm;
}
