// #include <tchar.h>
#include <sqlite3.h>
#include <stdio.h>

#pragma comment( lib, "sqlite3.lib" )

// 抽出結果が返るコールバック関数
static int callback(void *NotUsed, int argc, char **argv, char **azColName){
   int i;
   for(i=0; i<argc; i++)
      printf("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
   
   return SQLITE_OK;
}

void my_table_create(sqlite3 *db, const char *table_name)
{
	char *errMsg = NULL;
	
	char my_create_sql[] =
		"create table %s ("
		" id integer primary key, "
		" first_name text not null"
		")";

	char sql_str[512];

	sprintf(sql_str, my_create_sql, table_name);

	int rc = sqlite3_exec(db, sql_str, 0, 0, &errMsg);

	printf("%s : ret=%d, msg=%s\n", __FUNCTION__, rc, errMsg);
}

void my_insert_row(sqlite3 *db, const char *table_name, const int id, const char *name)
{
	char *errMsg = NULL;
	
	const char *insert_sql =
		"insert into %s ( id, first_name )"
		"values (%d, '%s')";

	char insert_record[512];
	
	sprintf(insert_record, insert_sql, table_name, id, name);

	int rc = sqlite3_exec(db, insert_record, 0, 0, &errMsg);

	printf("%s : ret=%d, msg=%s\n", __FUNCTION__, rc, errMsg);
}

int main (int argc, char *argv[])
{
   sqlite3 *db;
   char *zErrMsg = 0;

   // データベースファイルを新規生成
   int rc = sqlite3_open("Sample.db", &db);

   
   // 2013-03-03 test
   char table_name[256];
   sprintf(table_name, "%s", "member_list");
   my_table_create(db, table_name);
   my_insert_row(db, table_name, 1, "sami");
   my_insert_row(db, table_name, 2, "toshimitus");
   
   // データベースを閉じる
   sqlite3_close(db);
   
   return 0;
}

