#-------------------------------------------------------------------------------
# of_preRelease_v007_osx向けMakefile共通定義ファイル
# 各プロジェクトのMakefileからincludeして使用する
#
# OF_CORE_HEADERS : コンパイル時に使うincludeパス
# OF_LINK         : リンク時に使うライブラリとフレームワークの設定一式
#
# + of_preRelease_v007_osx.zipを展開する
# + MakefileのOF_PATHをof_preRelease_v007_osx.zip展開した場所
# + libs/fmodex/lib/osx/libfmodex.dylibは実行前に/usr/libとかへコピーしとく
#-------------------------------------------------------------------------------

## Openframework展開パス
#OF_PATH       = /Users/samb/work/of-make/of_preRelease_v007_osx
OF_PATH       = /Users/samb/work/OpenFrameworksMakeProj/of_preRelease_v007_osx

## ofライブラリヘッダのincludeパス
HEADER_OF        = "$(OF_PATH)/libs/openFrameworks/"
HEADER_FREETYPE  = "$(OF_PATH)/libs/freetype/include"
HEADER_FREETYPE2 = "$(OF_PATH)/libs/freetype/include/freetype2"
HEADER_POCO      = "$(OF_PATH)/libs/poco/include"
HEADER_FMODEX    = "$(OF_PATH)/libs/fmodex/include"
HEADER_GLEW      = "$(OF_PATH)/libs/glew/include"
HEADER_FREEIMAGE = "$(OF_PATH)/libs/FreeImage/include"
HEADER_TESS2     = "$(OF_PATH)/libs/tess2/include"
HEADER_CAIRO     = "$(OF_PATH)/libs/cairo/include/cairo"
HEADER_RTAUDIO   = "$(OF_PATH)/libs/rtaudio/include"

## of静的ライブラリのパス
LIB_OF           = "$(OF_PATH)/libs/openFrameworksCompiled/lib/osx/openFrameworksDebug.a"
LIB_FREEIMAGE    = "$(OF_PATH)/libs/FreeImage/lib/osx/freeimage.a"
LIB_FREETYPE     = "$(OF_PATH)/libs/freetype/lib/osx/freetype.a"
LIB_GLEW         = "$(OF_PATH)/libs/glew/lib/osx/glew.a"
LIB_POCOFOUNDATION = "$(OF_PATH)/libs/poco/lib/osx/PocoFoundation.a"
LIB_POCONET      = "$(OF_PATH)/libs/poco/lib/osx/PocoNet.a"
LIB_POCOUTIL     = "$(OF_PATH)/libs/poco/lib/osx/PocoUtil.a"
LIB_POCOXML      = "$(OF_PATH)/libs/poco/lib/osx/PocoXML.a"
LIB_RTAUDIO      = "$(OF_PATH)/libs/rtAudio/lib/osx/rtAudio.a"
LIB_TESS         = "$(OF_PATH)/libs/tess2/lib/osx/tess2.a"
LIB_CAIRO1       = "$(OF_PATH)/libs/cairo/lib/osx/cairo-script-interpreter.a"
LIB_CAIRO2       = "$(OF_PATH)/libs/cairo/lib/osx/cairo.a"
LIB_CAIRO3       = "$(OF_PATH)/libs/cairo/lib/osx/pixman-1.a"

## リンクするofライブラリ
OF_CORE_LIBS     = $(LIB_OF) $(LIB_MODEX) $(LIB_POCOFOUNDATION) $(LIB_POCONET) $(LIB_POCOXML) $(LIB_POCOUTIL) $(LIB_TESS) $(LIB_GLEW) $(LIB_CAIRO1) $(LIB_CAIRO2) $(LIB_CAIRO3) $(LIB_RTAUDIO)

## GLUT.frameworkは標準のものを使わずにofのものを使うのでパスを指定
OF_LDFLAGS     = -F$(OF_PATH)/libs/glut/lib/osx

## リンクするFramework
FRAMEWORK     = -framework AppKit \
				-framework Cocoa \
				-framework IOKit \
				-framework AGL \
				-framework ApplicationServices \
				-framework AudioToolbox \
				-framework Carbon \
				-framework CoreAudio \
				-framework CoreFoundation \
				-framework CoreServices \
				-framework OpenGL \
				-framework QuickTime \
				-framework GLUT

## fmodのみダイナミックリンク
OF_DYLIB       = -dylib $(OF_PATH)/libs/fmodex/lib/osx/libfmodex.dylib

## コンパイル時のヘッダ参照
OF_CORE_HEADERS  = -I$(HEADER_OF) -I$(HEADER_OF)/3d -I$(HEADER_OF)/app -I$(HEADER_OF)/communication -I$(HEADER_OF)/events \
					-I$(HEADER_OF)/gl -I$(HEADER_OF)/graphics -I$(HEADER_OF)/math -I$(HEADER_OF)/sound -I$(HEADER_OF)/types -I$(HEADER_OF)/utils -I$(HEADER_OF)/video \
					-I$(HEADER_POCO) -I$(HEADER_FREETYPE) -I$(HEADER_FREETYPE2) -I$(HEADER_FMODEX) -I$(HEADER_GLEW) -I$(HEADER_FREEIMAGE) -I$(HEADER_TESS2) -I$(HEADER_CAIRO) -I$(HEADER_RTAUDIO)

## リンク時にgccに渡す設定一式
OF_LINK        = $(OF_LDFLAGS) $(OF_CORE_LIBS) $(FRAMEWORK) $(OF_DYLIB)
