#include "GrButton.h"
#include "GrMouse.h"

GrButton::GrButton(double x, double y, double w, double h) :
	mx(x),
	my(y),
	mw(w),
	mh(h),
	mr(0),
	mg(200),
	mb(0)
{
	
}
	
void GrButton::update()
{

}

void GrButton::draw()
{
	double x = mx * ofGetWidth();
	double y = my * ofGetHeight();
	double w = mw * ofGetWidth();
	double h = mh * ofGetHeight();
	
	ofFill();
	ofSetColor(mr, mg, mb);
	ofSetPolyMode(OF_POLY_WINDING_ODD);
	ofBeginShape();
	ofVertex(x, y);
	ofVertex(x, y+h);
	ofVertex(x+w, y+h);
	ofVertex(x+w, y);
	ofEndShape();
}

//--------------------------------------------------------------
void GrButton::mouseMoved(int x, int y)
{
	double _x = mx * ofGetWidth();
	double _y = my * ofGetHeight();
	double _w = mw * ofGetWidth();
	double _h = mh * ofGetHeight();

	if( _x <= x && x <= (_x + _w) &&
		_y <= y && y <= (_y + _h)) {
		mg = 100;
	} else {
		mg = 200;
	}
}

//--------------------------------------------------------------
void GrButton::mouseDragged(int x, int y, int button)
{
	// dummy for virtual method
}

//--------------------------------------------------------------
void GrButton::mousePressed(int x, int y, int button)
{
	if( mx <= x && x <= (mx + mw) &&
		my <= y && y <= (my + mh)) {
		for(std::vector<ofPtr<GrButtonListener> >::iterator itr = mButtonListeners.begin();
			itr != mButtonListeners.end(); itr++) {
			((ofPtr<GrButtonListener>)*itr)->buttonNotify(GR_BUTTON_PRESSED, this);
		}
	}
	mr += 50;
	mr = mr % 255;
}

//--------------------------------------------------------------
void GrButton::mouseReleased(int x, int y, int button)
{
	// dummy for virtual method
}

void GrButton::addButtonListener(GrButtonListener *listener)
{
	// todo debug NULL Pointer
	mButtonListeners.push_back(ofPtr<GrButtonListener>(listener));
}

void GrButton::setColor(int r, int g, int b)
{
	mr = r;
	mg = g;
	mb = b;
}
