/*
 * Resizable.h
 *
 *  Created on: 2009/03/07
 *      Author: ox
 */

#ifndef RESIZABLE_H_
#define RESIZABLE_H_

#include "SizePort.h"
#include "graphic/DeadNotifier.h"

class Resizable : public DeadNotifier {
public:
	Resizable(float size = 0.1);
	virtual ~Resizable();

	virtual void *setSize(Resizable *resizable);
	virtual void setSize(float size);
	float getSize();
	float getSizePixel();
	SizePort *getSizePort();

	void setWidth(float width);
	float getWidth();
	float getWidthPixel();
	WidthPort *getWidthPort();

	void setHeight(float height);
	float getHeight();
	float getHeightPixel();
	HeightPort *getHeightPort();

protected:
	/*!
	 * Normalized(0~1) Value
	 */
	float nsize;
	float width;
	float height;

	/*!
	 * Pixel Value
	 */
	float sizePixel, pixelSizeH;	//! size
	float widthPixel;
	float heightPixel;
};

#endif /* RESIZABLE_H_ */
