//
//  GrObject.cpp
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/28.
//
//

#include "ofMain.h"
#include "GrPoint.h"
#include "GrPort.h"

GrPoint::GrPoint(float x, float y, float size) :
    portX(new GrPort()),
    portY(new GrPort()),
    portR(new GrPort()),
    portG(new GrPort()),
    portB(new GrPort()),
    x(x), y(y), size(size)
{
    addPort("x", portX);
    addPort("y", portY);
    addPort("r", portR);
    addPort("g", portG);
    addPort("b", portB);
    
    portX->set(x);
    portY->set(y);
    portR->set(100);
    portG->set(100);
    portB->set(100);
}

GrPoint::~GrPoint()
{
    
}

void GrPoint::draw()
{
    ofPushStyle();
    //ofSetColor(100, 100, 255);
    ofSetColor(portR->get(), portG->get(), portB->get());
    //ofCircle(x, y, size);
    ofCircle(portX->get(), portY->get(), size);
    ofPopStyle();
}

void GrPoint::mousePressed(int x, int y, int button)
{

}

bool GrPoint::grab2d(float x, float y)
{
    ofVec2f me(this->x, this->y);
    ofVec2f grab(x, y);
    float dist = me.distance(grab);
    if(dist < size) {
        return true;
    }
    return false;
}
