//
//  GrUnit.h
//  myNewApp
//
//  Created by 三分一 修 on 2012/10/05.
//
//

#ifndef __myNewApp__GrUnit__
#define __myNewApp__GrUnit__

#include <iostream>
#include <map>

#include "ofMain.h"
#include "GrBase.h"
#include "DeadNotifier.h"

class GrPort;

class GrUnit : public virtual GrBase, public DeadNotifier
{
public:
    virtual ~GrUnit();
    
    /*
     * keyで指定したキーに対応するポートを取り出す
     */
    GrPort *getPortByName(const std::string &key);
    
    /*
     * keyで指定したキーに対応するポートにvalue値を設定する
     * keyで指定したキーに対応するポートがなければfalseを返す
     */
    bool setPortValue(const std::string &key, float value); //
    
protected:
    void addPort(std::string portName, GrPort *grPort);
    
private:
    std::map<std::string, ofPtr<GrPort> > unitPortMap;
};

#endif /* defined(__myNewApp__GrUnit__) */
