/*
 *  The MIT License
 *
 *  Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader;

import android.app.IntentService;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.routine_work.simple_battery_logger.dropbox_uploader.db.CsvUploadStatusDBHelper;
import org.routine_work.util.Log;

/**
 *
 * @author sawai
 */
public class UploadNewCsvFilesService extends IntentService
{

	private static final String LOG_TAG = "simple-battery-logger-dropbox";
	private static final int MAX_DELAY_TIME_IN_SEC = 60;
	private CsvUploadStatusDBHelper dbHelper;
	private SQLiteDatabase db;

	public UploadNewCsvFilesService(String name)
	{
		super(name);
	}

	public UploadNewCsvFilesService()
	{
		this("UploadNewCsvFilesService");
	}

	@Override
	public void onCreate()
	{
		super.onCreate();
		dbHelper = new CsvUploadStatusDBHelper(this);
		db = dbHelper.getWritableDatabase();
	}

	@Override
	public void onDestroy()
	{
		if (db != null)
		{
			db.close();
		}
		super.onDestroy();
	}

	@Override
	protected void onHandleIntent(Intent intent)
	{
		Log.i(LOG_TAG, "UploadNewCsvFilesService  : Start at " + new Date());

		randomizeUploadStartTime();

		boolean forceUpload = intent.getBooleanExtra(BatteryConstants.EXTRA_FORCE_UPLOAD, false);
		Log.d(LOG_TAG, "UploadNewCsvFilesService  : forceUpload =>  " + forceUpload);
		if (forceUpload)
		{
			dbHelper.deleteAll(db);
		}

		List<String> uploadTargetCsvFilePathList = UploadServiceUtils.getNewCsvFilePathList(this);
		Log.d(LOG_TAG, "UploadNewCsvFilesService : uploadTargetCsvFilePathList.size" + uploadTargetCsvFilePathList.size());
		if (uploadTargetCsvFilePathList.size() > 0)
		{
			String[] csvFilePaths = uploadTargetCsvFilePathList.toArray(new String[0]);

			// start uploading
			Intent uploadCsvFilesServiceIntent = new Intent(this, UploadCsvFilesService.class);
			uploadCsvFilesServiceIntent.putExtra(BatteryConstants.EXTRA_CSV_FILE_PATHS, csvFilePaths);
			startService(uploadCsvFilesServiceIntent);
		}

		Log.i(LOG_TAG, "UploadNewCsvFilesService : End at " + new Date());
	}

	/**
	 * Wait 0 - MAX_WAIT_TIME_IN_SEC sec.
	 */
	private void randomizeUploadStartTime()
	{
		Random random = new Random();
		long waitTimeInMilis = random.nextInt(MAX_DELAY_TIME_IN_SEC) * 1000;
		try
		{
			Thread.sleep(waitTimeInMilis);
		}
		catch (InterruptedException e)
		{
			Log.w(LOG_TAG, e.getLocalizedMessage(), e);
		}
	}
}
