/*
 *  The MIT License
 *
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.util;

import org.routine_work.utils.Log;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import org.routine_work.simple_battery_logger.R;

/**
 *
 * @author sawai
 */
public class PreferenceUtils
{

	private static final String LOG_TAG = "simple-battery-logger";

	public static boolean isLoggingServiceEnabled(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.logging_service_enabled_key);
		boolean defaultValue = resources.getBoolean(R.bool.logging_service_enabled_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "loggingServiceEnabled => " + value);
		return value;
	}

	public static boolean isIgnoreVoltageChangeOnly(Context context)
	{

		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.ignore_voltage_change_only_key);
		boolean defaultValue = resources.getBoolean(R.bool.ignore_voltage_change_only_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "ignoreVoltageChangeOnly => " + value);
		return value;
	}

	public static int getDataKeepingPeriod(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.data_keeping_period_key);
		String defaultValue = resources.getString(R.string.data_keeping_period_default_value);
		String valueString = sharedPreferences.getString(key, defaultValue);
		int dataKeepingPeriod = Integer.parseInt(valueString);

		Log.v(LOG_TAG, "dataKeepingPeriod => " + dataKeepingPeriod);
		return dataKeepingPeriod;
	}

	public static boolean isCsvAutoExportEnabled(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_auto_export_enabled_key);
		boolean defaultValue = resources.getBoolean(R.bool.csv_auto_export_enabled_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "csvAutoExportEnabled => " + value);
		return value;
	}

	public static String getCsvSortOrder(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_sort_order_key);
		String defaultValue = resources.getString(R.string.csv_sort_order_default_value);
		String value = sharedPreferences.getString(key, defaultValue);

		Log.v(LOG_TAG, "csvSortOrder => " + value);
		return value;
	}

	public static String getCsvExportDirectoryName(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_export_directory_key);
		String defaultValue = resources.getString(R.string.csv_export_directory_default_value);
		String value = sharedPreferences.getString(key, defaultValue);

		Log.v(LOG_TAG, "csvExportDirectory => " + value);
		return value;
	}
}
