/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_layout_sample;

import android.app.ListActivity;
import android.os.Bundle;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutSampleActivity extends ListActivity
{

	public static final String EXTRA_LAYOUT_ID = LayoutSampleActivity.class.getPackage().getName() + ".EXTRA_LAYOUT_ID";
	public static final String EXTRA_LAYOUT_NAME = LayoutSampleActivity.class.getPackage().getName() + ".EXTRA_LAYOUT_NAME";
	private static final int DEFAULT_LAYOUT_ID = android.R.layout.simple_list_item_2;
	private static final String DEFAULT_LAYOUT_NAME = "simple_list_item_2";
	private static final String MAPPING_KEY_NAME = "name";
	private static final String MAPPING_KEY_EMAIL = "email";
	private static final String MAPPING_KEY_ICON = "icon";
	private static final String[] MAPPING_FROM =
	{
		MAPPING_KEY_ICON,
		MAPPING_KEY_NAME,
		MAPPING_KEY_EMAIL,
	};
	private static final int[] MAPPING_TO =
	{
		android.R.id.icon,
		android.R.id.text1,
		android.R.id.text2,
	};
	private List<Map<String, String>> userList;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.list_activity);

		int listItemLayoutID = getIntent().getExtras().getInt(EXTRA_LAYOUT_ID, DEFAULT_LAYOUT_ID);
		String listItemLayoutName = getIntent().getExtras().getString(EXTRA_LAYOUT_NAME);
		if (listItemLayoutName == null || listItemLayoutName.length() == 0)
			listItemLayoutName = DEFAULT_LAYOUT_NAME;
		setTitle(listItemLayoutName);

		// initialize list adapter
		SimpleAdapter simpleAdapter = new SimpleAdapter(this, getUserList(),
			listItemLayoutID, MAPPING_FROM, MAPPING_TO);

		ListView listView = (ListView) findViewById(android.R.id.list);
		listView.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);

		setListAdapter(simpleAdapter);
	}

	private List<Map<String, String>> getUserList()
	{
		if (userList == null)
		{
			// initialize userList
			userList = new ArrayList<Map<String, String>>();
			String[] userNames = getResources().getStringArray(R.array.names);
			for (String name : userNames)
			{
				Map<String, String> user = new HashMap<String, String>();
				user.put(MAPPING_KEY_NAME, name);
				user.put(MAPPING_KEY_EMAIL, name.toLowerCase() + "@example.com");
				user.put(MAPPING_KEY_ICON, String.valueOf(android.R.drawable.sym_def_app_icon));
				userList.add(user);
			}
		}
		return userList;
	}
}
