/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_multiple_choice_custom_layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Checkable;
import android.widget.FrameLayout;

public class NameAndEmailView extends FrameLayout implements Checkable
{

	private Checkable checkableView;

	public NameAndEmailView(Context context, AttributeSet attrs, int defStyle)
	{
		super(context, attrs, defStyle);
		initChildViews();
	}

	public NameAndEmailView(Context context, AttributeSet attrs)
	{
		super(context, attrs);
		initChildViews();
	}

	public NameAndEmailView(Context context)
	{
		super(context);
		initChildViews();
	}

	private void initChildViews()
	{
		LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View view = inflater.inflate(R.layout.name_and_email, null, false);
		checkableView = (Checkable) view.findViewById(R.id.checkable);
		addView(view);
	}

	public void toggle()
	{
		checkableView.toggle();
	}

	public void setChecked(boolean checked)
	{
		checkableView.setChecked(checked);
	}

	public boolean isChecked()
	{
		return checkableView.isChecked();
	}
}
