/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_single_choice_checkable_layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.LinearLayout;

public class CheckableLinearLayout extends LinearLayout implements Checkable
{

	private Checkable checkableView;

	public CheckableLinearLayout(Context context, AttributeSet attrs)
	{
		super(context, attrs);
	}

	public CheckableLinearLayout(Context context)
	{
		super(context);
	}

	public Checkable getCheckableView()
	{
		if (checkableView == null)
		{
			View view = this.findViewById(android.R.id.checkbox);
			if (view instanceof Checkable)
			{
				checkableView = (Checkable) view;
			}
			else
			{
				throw new IllegalStateException("No Checkable View");
			}
		}
		return checkableView;
	}

	public void toggle()
	{
		getCheckableView().toggle();
	}

	public void setChecked(boolean checked)
	{
		getCheckableView().setChecked(checked);
	}

	public boolean isChecked()
	{
		return getCheckableView().isChecked();
	}
}
