/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.service_and_sqlite;

import android.app.Service;
import android.content.ContentValues;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 *
 * @author sawai
 */
public class CountDownService extends Service
	implements Runnable
{

	private static final long COUNT_INTERVAL_MSEC = 1000; // 1sec
	private static final int COUNT = 10;
	public static final String LOG_TAG = "XXX";
	private CountDownDBOpenHelper dbOpenHelper;
	private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private Handler handler;
	private boolean running;
	private int count;

	@Override
	public void onCreate()
	{
		Log.d(LOG_TAG, "onCreate()");
		super.onCreate();
		dbOpenHelper = new CountDownDBOpenHelper(this);
		handler = new Handler();
		running = false;
	}

	@Override
	public void onDestroy()
	{
		Log.d(LOG_TAG, "onDestroy()");
		running = false;
		super.onDestroy();
	}

	@Override
	public void onStart(Intent intent, int startId)
	{
		Log.d(LOG_TAG, "onStart()");
		super.onStart(intent, startId);
		if (!running)
		{
			running = true;
			count = COUNT;
			handler.postDelayed(this, COUNT_INTERVAL_MSEC);
		}
	}

	@Override
	public IBinder onBind(Intent arg0)
	{
		Log.d(LOG_TAG, "onBind()");
		return null;
	}

	public void run()
	{
		Log.d(LOG_TAG, "run() count : " + count);
		if (running)
		{
			insertCountDownData(count);
			count--;
			if (count <= 0)
			{
				stopSelf();
			}
			else
			{
				handler.postDelayed(this, COUNT_INTERVAL_MSEC);
			}
		}
	}

	private void insertCountDownData(int count)
	{
		SQLiteDatabase db = dbOpenHelper.getWritableDatabase();
		try
		{
			Calendar now = Calendar.getInstance();
			String datetimeString = dateFormat.format(now.getTime());
			ContentValues values;
			values = new ContentValues();
			values.put("datetime", datetimeString);
			values.put("count", count);
			db.insert(CountDownDBOpenHelper.TABLE_NAME, null, values);
		}
		catch (Exception e)
		{
			Log.d(LOG_TAG, "insert error", e);
		}
		finally
		{
			db.close();
		}
	}
}
