/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.service_bind_without_aidl;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity
	implements ServiceConnection, OnClickListener
{

	public static final int DELAY_TIME_IN_MSEC = 1000;
	public static final String LOG_TAG = "XXX";
	private CountDownService countDownService;
	private Handler handler = new Handler();
	private Runnable updateCountTask = new Runnable()
	{
		public void run()
		{
			updateCountText();
			handler.postDelayed(this, DELAY_TIME_IN_MSEC);
		}
	};

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		Log.d(LOG_TAG, "MainActivity#onCreate() Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);


		Button startServiceButton = (Button) findViewById(R.id.start_count_button);
		startServiceButton.setOnClickListener(this);
		Button stopServiceButton = (Button) findViewById(R.id.stop_count_button);
		stopServiceButton.setOnClickListener(this);

		Log.d(LOG_TAG, "MainActivity#onCreate() Bye");
	}

	@Override
	protected void onStart()
	{
		Log.d(LOG_TAG, "MainActivity#onStart() Bye");
		super.onStart();
		Log.d(LOG_TAG, "MainActivity#onStart() Bye");
	}

	@Override
	protected void onStop()
	{
		Log.d(LOG_TAG, "MainActivity#onStop() Hello");
		super.onStop();
		Log.d(LOG_TAG, "MainActivity#onStop() Bye");
	}

	@Override
	protected void onResume()
	{
		Log.d(LOG_TAG, "MainActivity#onResume() Hello");

		super.onResume();

		Intent intent = new Intent(this, CountDownService.class);
		bindService(intent, this, BIND_AUTO_CREATE);

		handler.postDelayed(updateCountTask, DELAY_TIME_IN_MSEC);

		Log.d(LOG_TAG, "MainActivity#onResume() Bye");
	}

	@Override
	protected void onPause()
	{
		Log.d(LOG_TAG, "MainActivity#onPause() Hello");

		handler.removeCallbacks(updateCountTask);

		unbindService(this);

		super.onPause();

		Log.d(LOG_TAG, "MainActivity#onPause() Bye");
	}

	public void onClick(View view)
	{
		int id = view.getId();
		switch (id)
		{
			case R.id.start_count_button:
				startCountDown();
				break;
			case R.id.stop_count_button:
				stopCountDown();
				break;
			default:
				throw new AssertionError();
		}
	}

	/**
	 * ServiceConnection
	 *
	 * @param cn
	 * @param ib
	 */
	@Override
	public void onServiceConnected(ComponentName cn, IBinder ib)
	{
		Log.d(LOG_TAG, "MainActivity#onServiceConnected() Hello");

		CountDownServiceBinder binder = (CountDownServiceBinder) ib;
		countDownService = binder.getCountDownService();

		Log.d(LOG_TAG, "MainActivity#onServiceConnected() Bye");
	}

	/**
	 * ServiceConnection
	 *
	 * @param cn
	 */
	@Override
	public void onServiceDisconnected(ComponentName cn)
	{
		Log.d(LOG_TAG, "MainActivity#onServiceDisconnected() Hello");
		countDownService = null;
		Log.d(LOG_TAG, "MainActivity#onServiceDisconnected() Bye");
	}

	private void updateCountText()
	{
		if (countDownService != null)
		{
			int count = countDownService.getCount();
			TextView countTextView = (TextView) findViewById(R.id.count_textview);
			countTextView.setText(String.valueOf(count));
		}

	}

	private void startCountDown()
	{
		Toast.makeText(getApplicationContext(), "Start Count Down", Toast.LENGTH_SHORT).show();
		if (countDownService != null)
		{
			countDownService.startCountDown();
		}
	}

	private void stopCountDown()
	{
		Toast.makeText(getApplicationContext(), "Stop Count Down", Toast.LENGTH_SHORT).show();
		if (countDownService != null)
		{
			countDownService.stopCountDown();
		}
	}
}
