/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

public class GrowthByteBuffer {
    private static final int DefaultBufferSize = 16384;
    private byte[][] buffer;
    private int position;
    private int limit;

    public GrowthByteBuffer() {
        this(16384);
    }

    public GrowthByteBuffer(int BufferSize) {
        if (0 >= BufferSize) {
            throw new IllegalArgumentException("BufferSize most be 1 or more.");
        }
        this.buffer = new byte[16][];
        this.buffer[0] = new byte[BufferSize];
        this.position = 0;
        this.limit = -1;
    }

    public void write(int data) {
        this.grow(this.position);
        this.buffer[this.position / this.buffer[0].length][this.position % this.buffer[0].length] = (byte)data;
        ++this.position;
    }

    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int index, int length) {
        this.grow(this.position + length - 1);
        while (0 < length) {
            int copylen = Math.min((this.position / this.buffer[0].length + 1) * this.buffer[0].length, this.position + length) - this.position;
            System.arraycopy(buffer, index, this.buffer[this.position / this.buffer[0].length], this.position % this.buffer[0].length, copylen);
            this.position += copylen;
            index += copylen;
            length -= copylen;
        }
    }

    public int read() {
        if (this.position <= this.limit) {
            return this.buffer[this.position / this.buffer[0].length][this.position++ % this.buffer[0].length] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int index, int length) {
        if (this.position <= this.limit) {
            int copylen;
            int len = 0;
            while (0 < length && 0 < (copylen = Math.min(Math.min((this.position / this.buffer[0].length + 1) * this.buffer[0].length, this.position + length), this.limit + 1) - this.position)) {
                System.arraycopy(this.buffer[this.position / this.buffer[0].length], this.position % this.buffer[0].length, buffer, index, copylen);
                this.position += copylen;
                index += copylen;
                len += copylen;
                length -= copylen;
            }
            return len;
        }
        if (0 < length) {
            return -1;
        }
        return 0;
    }

    public int length() {
        return this.limit + 1;
    }

    public void setLength(int length) {
        if (this.limit < --length) {
            this.grow(length);
        } else {
            this.limit = length;
        }
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void seek(int position) {
        this.setPosition(position);
    }

    private void grow(int limit) {
        if (this.limit < limit) {
            int last;
            for (last = 0; last < this.buffer.length && this.buffer[last] != null; ++last) {
            }
            if (last * this.buffer[0].length < ++limit) {
                int need = limit / this.buffer[0].length + (limit % this.buffer[0].length == 0 ? 0 : 1);
                if (this.buffer.length < need) {
                    byte[][] old = this.buffer;
                    this.buffer = new byte[Math.max(old.length * 2, need)][];
                    for (int i = 0; i < last; ++i) {
                        this.buffer[i] = old[i];
                    }
                }
                for (int i = last; i < need; ++i) {
                    this.buffer[i] = new byte[this.buffer[0].length];
                }
            }
            this.limit = limit - 1;
        }
    }
}

