/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private InputStream in;
    private long position;
    private final long limit;
    private long markPosition;

    public LimitedInputStream(InputStream in, long limit) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (0L > limit) {
            throw new IllegalArgumentException("limit must be 0 or more.");
        }
        this.in = in;
        this.position = 0L;
        this.limit = limit;
        this.markPosition = -1L;
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.limit) {
            int ret = this.in.read();
            if (0 <= ret) {
                ++this.position;
            }
            return ret;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        if (0 < buffer.length) {
            int ret;
            if ((long)buffer.length < this.limit - this.position) {
                ret = this.in.read(buffer);
            } else if (this.position < this.limit) {
                ret = this.in.read(buffer, 0, (int)(this.limit - this.position));
            } else {
                return -1;
            }
            if (0 < ret) {
                this.position += (long)ret;
            }
            return ret;
        }
        return 0;
    }

    @Override
    public int read(byte[] buffer, int index, int length) throws IOException {
        if (0 < length) {
            int ret;
            if (this.limit <= this.position) {
                return -1;
            }
            if (this.limit - this.position < (long)length) {
                length = (int)(this.limit - this.position);
            }
            if (0 < (ret = this.in.read(buffer, index, length))) {
                this.position += (long)ret;
            }
            return ret;
        }
        return 0;
    }

    @Override
    public long skip(long length) throws IOException {
        if (0L < length) {
            if (this.limit <= this.position) {
                return 0L;
            }
            if (this.limit - this.position < length) {
                length = this.limit - this.position;
            }
            if (0L < (length = this.in.skip(length))) {
                this.position += length;
            }
            return length;
        }
        return 0L;
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
        this.markPosition = this.position;
    }

    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("not support mark()/reset().");
        }
        if (this.markPosition < 0L) {
            throw new IOException("not marked.");
        }
        this.in.reset();
        this.position = this.markPosition;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.limit - this.position);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }
}

