/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jp.gr.java_conf.dangan.lang.reflect.Type;

public class MethodUtil {
    private MethodUtil() {
    }

    public static Object invoke(Object obj, String name, Object[] args) throws InvocationTargetException, NoSuchMethodException {
        Class<?> type = obj.getClass();
        Method method = MethodUtil.getMatchFullInstanceMethod(type, name, args);
        if (method == null && (method = MethodUtil.getInstanceMethod(type, name, args)) != null) {
            args = Type.parseAll(method.getParameterTypes(), args);
        }
        if (method != null) {
            try {
                return method.invoke(obj, args);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalAccessError(exception.toString());
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object invokeStatic(String classname, String name, Object[] args) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        return MethodUtil.invokeStatic(Class.forName(classname), name, args);
    }

    public static Object invokeStatic(Class<?> type, String name, Object[] args) throws InvocationTargetException, NoSuchMethodException {
        Method method = MethodUtil.getMatchFullStaticMethod(type, name, args);
        if (method == null && (method = MethodUtil.getStaticMethod(type, name, args)) != null) {
            args = Type.parseAll(method.getParameterTypes(), args);
        }
        if (method != null) {
            try {
                return method.invoke(null, args);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalAccessError(exception.toString());
            }
        }
        throw new NoSuchMethodException();
    }

    public static Method getInstanceMethod(String classname, String name, Object[] args) throws ClassNotFoundException {
        return MethodUtil.getInstanceMethod(Class.forName(classname), name, args, false);
    }

    public static Method getInstanceMethod(Class<?> type, String name, Object[] args) {
        return MethodUtil.getInstanceMethod(type, name, args, false);
    }

    public static Method getInstanceMethod(String classname, String name, Object[] args, boolean all) throws ClassNotFoundException {
        return MethodUtil.getInstanceMethod(Class.forName(classname), name, args, all);
    }

    public static Method getInstanceMethod(Class<?> type, String name, Object[] args, boolean all) {
        int i;
        Method[] methods = all ? type.getDeclaredMethods() : type.getMethods();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || Modifier.isStatic(methods[i].getModifiers()) || !Type.matchFullAll(methods[i].getParameterTypes(), args)) continue;
            return methods[i];
        }
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || Modifier.isStatic(methods[i].getModifiers()) || !Type.matchRestrictAll(methods[i].getParameterTypes(), args)) continue;
            return methods[i];
        }
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || Modifier.isStatic(methods[i].getModifiers()) || !Type.matchAll(methods[i].getParameterTypes(), args)) continue;
            return methods[i];
        }
        return null;
    }

    public static Method getMatchFullInstanceMethod(String classname, String name, Object[] args) throws ClassNotFoundException {
        return MethodUtil.getMatchFullInstanceMethod(Class.forName(classname), name, args, false);
    }

    public static Method getMatchFullInstanceMethod(Class<?> type, String name, Object[] args) {
        return MethodUtil.getMatchFullInstanceMethod(type, name, args, false);
    }

    public static Method getMatchFullInstanceMethod(String classname, String name, Object[] args, boolean all) throws ClassNotFoundException {
        return MethodUtil.getMatchFullInstanceMethod(Class.forName(classname), name, args, all);
    }

    public static Method getMatchFullInstanceMethod(Class<?> type, String name, Object[] args, boolean all) {
        Method[] methods = all ? type.getDeclaredMethods() : type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || Modifier.isStatic(methods[i].getModifiers()) || !Type.matchFullAll(methods[i].getParameterTypes(), args)) continue;
            return methods[i];
        }
        return null;
    }

    public static Method getStaticMethod(String classname, String name, Object[] args) throws ClassNotFoundException {
        return MethodUtil.getStaticMethod(Class.forName(classname), name, args, false);
    }

    public static Method getStaticMethod(Class<?> type, String name, Object[] args) {
        return MethodUtil.getStaticMethod(type, name, args, false);
    }

    public static Method getStaticMethod(String classname, String name, Object[] args, boolean all) throws ClassNotFoundException {
        return MethodUtil.getStaticMethod(Class.forName(classname), name, args, all);
    }

    public static Method getStaticMethod(Class<?> type, String name, Object[] args, boolean all) {
        int i;
        Method[] methods = all ? type.getDeclaredMethods() : type.getMethods();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || !Modifier.isStatic(methods[i].getModifiers()) || !Type.matchFullAll(methods[i].getParameterTypes(), args)) continue;
            return methods[i];
        }
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || !Modifier.isStatic(methods[i].getModifiers()) || !Type.matchRestrictAll(methods[i].getParameterTypes(), args)) continue;
            return methods[i];
        }
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || !Modifier.isStatic(methods[i].getModifiers()) || !Type.matchAll(methods[i].getParameterTypes(), args)) continue;
            return methods[i];
        }
        return null;
    }

    public static Method getMatchFullStaticMethod(String classname, String name, Object[] args) throws ClassNotFoundException {
        return MethodUtil.getMatchFullStaticMethod(Class.forName(classname), name, args, false);
    }

    public static Method getMatchFullStaticMethod(Class<?> type, String name, Object[] args) {
        return MethodUtil.getMatchFullStaticMethod(type, name, args, false);
    }

    public static Method getMatchFullStaticMethod(String classname, String name, Object[] args, boolean all) throws ClassNotFoundException {
        return MethodUtil.getMatchFullStaticMethod(Class.forName(classname), name, args, all);
    }

    public static Method getMatchFullStaticMethod(Class<?> type, String name, Object[] args, boolean all) {
        Method[] methods = all ? type.getDeclaredMethods() : type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || !Modifier.isStatic(methods[i].getModifiers()) || !Type.matchFullAll(methods[i].getParameterTypes(), args)) continue;
            return methods[i];
        }
        return null;
    }
}

